package tacos.security;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.
                                              UserDetailsService;
import org.springframework.security.core.userdetails.
                                       UsernameNotFoundException;
import org.springframework.stereotype.Service;

import tacos.User;
import tacos.data.UserRepository;

@Service
public class UserRepositoryUserDetailsService 
        implements UserDetailsService {

  private UserRepository userRepo;

  @Autowired
  public UserRepositoryUserDetailsService(UserRepository userRepo) {
    this.userRepo = userRepo;
  }
  
  @Override
  public UserDetails loadUserByUsername(String username)
      throws UsernameNotFoundException {

    // TODO: Należy zastąpić odpowiednikiem reaktywnym zamiast stosować blokowanie
    User user = userRepo.findByUsername(username).block();
    if (user != null) {
      return user;
    }
    throw new UsernameNotFoundException(
                    "Użytkownik '" + username + "' nie został znaleziony.");
  }

}
