<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<html>
<head>
<title>Formularz rezerwacji</title>
<style>
.error {
  color: #ff0000;
  font-weight: bold;
}
</style>
</head>

<body>
<form:form method="post" modelAttribute="reservation">
<form:errors path="*" cssClass="error" />
<table>
  <tr>
    <td>Nazwa kortu</td>
    <td><form:input path="courtName" /></td>
    <td><form:errors path="courtName" cssClass="error" /></td>
  </tr>
  <tr>
    <td>Data</td>
    <td><form:input path="date" /></td>
    <td><form:errors path="date" cssClass="error" /></td>
  </tr>
  <tr>
    <td>Godzina</td>
    <td><form:input path="hour" /></td>
    <td><form:errors path="hour" cssClass="error" /></td>
  </tr>
  <tr>
    <td>Nazwisko gracza</td>
    <td><form:input path="player.name" /></td>
    <td><form:errors path="player.name" cssClass="error" /></td>
  </tr>
  <tr>
    <td>Telefon gracza</td>
    <td><form:input path="player.phone" /></td>
    <td><form:errors path="player.phone" cssClass="error" /></td>
  </tr>
  <tr>
    <td>Dyscyplina</td>
    <td>
      <form:select path="sportType" items="${sportTypes}"
        itemValue="id" itemLabel="name" />
    </td>
    <td><form:errors path="sportType" cssClass="error" /></td>
  </tr>
  <tr>
    <td colspan="3"><input type="submit" /></td>
  </tr>
</table>
</form:form>
</body>
</html>
