package com.apress.springrecipes.shop;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {

    public static void main(String[] args) throws Exception {
        ApplicationContext context = 
            new ClassPathXmlApplicationContext("beans.xml");

        Product aaa = (Product) context.getBean("aaa");
        Product cdrw = (Product) context.getBean("cdrw");
        Product dvdrw = (Product) context.getBean("dvdrw");

        ShoppingCart cart1 = (ShoppingCart) context.getBean("shoppingCart");
        cart1.addItem(aaa);
        cart1.addItem(cdrw);
        System.out.println("Koszyk zakupów 1 zawiera: " + cart1.getItems());

        ShoppingCart cart2 = (ShoppingCart) context.getBean("shoppingCart");
        cart2.addItem(dvdrw);
        System.out.println("Koszyk zakupów 2 zawiera: " + cart2.getItems());

        Cashier cashier1 = (Cashier) context.getBean("cashier1");
        cashier1.checkout(cart1);

        ProductRanking productRanking =
            (ProductRanking) context.getBean("productRanking");
        System.out.println(
                "Ranking produktów od dnia " + productRanking.getFromDate() +
                " do dnia " +productRanking.getToDate());
    }
}
