package com.apress.springrecipes.city.filter;

import com.apress.springrecipes.city.CityServiceRequestAuditor;

import javax.servlet.*;
import java.io.IOException;
import java.util.Map;


/**
 * Ta klasa przechwytuje żądania do klasy {@link com.apress.springrecipes.city.CityServiceImpl} i rejestruje je
 */
public class CityServiceRequestFilter implements Filter {
    private CityServiceRequestAuditor cityServiceRequestAuditor;

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain)
        throws IOException, ServletException {
        Map parameterMap = servletRequest.getParameterMap();

        this.cityServiceRequestAuditor.log(parameterMap);

        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
    }

    public void setCityServiceRequestAuditor(final CityServiceRequestAuditor cityServiceRequestAuditor) {
        this.cityServiceRequestAuditor = cityServiceRequestAuditor;
    }
}
