// Wersja końcowa 
package com.apress.springrecipes.court.web;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class ExtensionInterceptor extends HandlerInterceptorAdapter {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, //Model model) throws Exception {
    ModelAndView modelAndView) throws Exception {
        // Data jest podawana w żądaniu
        String reportName = null;
        String reportDate = request.getQueryString().replace("date=", "").replace("-", "_");

        if (request.getServletPath().endsWith(".pdf")) {
            reportName = "ReservationSummary_" + reportDate + ".pdf";
        }

        if (request.getServletPath().endsWith(".xls")) {
            reportName = "ReservationSummary_" + reportDate + ".xls";
        }

        // TYLKO jeśli rozszerzenie to PDF lub XLS, należy zmienić adres URL odpowiedzi.
        // Jeżeli zmodyfikowano nazwę reportName, używany format to PDF lub XLS
        if (reportName != null) {
            // Należy ustawić nagłówek HTTP "Content-Disposition",
			// aby użytkownicy zobaczyli elegancki adres w oknie "Zapisz jako"
            response.setHeader("Content-Disposition", "attachment; filename=" + reportName);
        }
    }
}
