// Końcowa wersja
package com.apress.springrecipes.court.web;

import java.util.List;

import com.apress.springrecipes.court.domain.Reservation;
import com.apress.springrecipes.court.service.ReservationService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.ui.Model;


@Controller
// Wiązanie kontrolera z adresem URL /reservationQuery.
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/reservationQuery")
public class ReservationQueryController {
    
    private ReservationService reservationService;

    // Podłączanie usługi w konstruktorze
    @Autowired
    public ReservationQueryController(ReservationService reservationService) {
        this.reservationService = reservationService;
    }

	// Kontroler zawsze szuka domyślnej metody obsługi żądań GET (jej nazwa nie ma znaczenia).
    // Tu ta metoda nosi nazwę setupForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.GET)
    public void setupForm() { 
	// Metoda zwraca void, dlatego używany jest domyślny widok odpowiadający adresowi URL (reservationQuery)
	// (@RequestMapping(/reservationQuery)).
	// Na podstawie konfiguracji widok reservationQuery
	// jest wiązany z plikiem JSP /WEB-INF/jsp/reservationQuery.jsp.
    }

	// Kontroler zawsze szuka domyślnej metody obsługi żądań POST (nazwa nie ma tu znaczenia),
    // gdy zgłaszane jest żądanie danego adresu URL (@RequestMapping(/periodicReservationForm)).
    // Tu ta metoda nosi nazwę submitForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.POST)
	// W żądaniu znajduje się pole courtName. Ponadto dodawany jest model.
    public String sumbitForm(@RequestParam("courtName") String courtName, Model model) {
	// Tworzenie listy rezerwacji
	List<Reservation> reservations = java.util.Collections.emptyList();
	// Zgłaszanie zapytania, jeśli parametr jest różny od null
        if (courtName != null) {
            reservations = reservationService.query(courtName);
        }
	// Aktualizowanie modelu - dołączanie rezerwacji
	model.addAttribute("reservations", reservations);
	// Zwracanie łańcucha znaków z widokiem
	// Na podstawie konfiguracji widok reservationQuery jest wiązany
	// z plikiem JSP /WEB-INF/jsp/reservationQuery.jsp 
        return "reservationQuery";
    }
}