<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<html>
<head>
    <title>Lista książek</title>
</head>

<body>
<table border="1">
    <tr>
        <th>ISBN</th>
        <th>Tytuł</th>
        <th>Autor</th>
        <th>Data wydania</th>
    </tr>
    <c:forEach items="${books}" var="book">
        <tr>
            <td>
                <a href="${flowExecutionUrl}&_eventId=select&isbn=${book.isbn}">
                        ${book.isbn}
                </a>
            </td>
            <td>${book.name}</td>
            <td>${book.author}</td>
            <td><fmt:formatDate value="${book.publishDate}" pattern="yyyy-MM-dd"/></td>
        </tr>
    </c:forEach>
</table>
<a href="${flowExecutionUrl}&_eventId=newSearch">Nowe wyszukiwanie</a>
</body>
</html>
