// Wersja końcowa
package com.apress.springrecipes.court.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.apress.springrecipes.court.domain.Reservation;
import com.apress.springrecipes.court.service.ReservationService;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.ui.Model;


import java.io.StringWriter;
import java.io.PrintWriter;

@Controller
// Wiązanie kontrolera z adresem URL /reservationSummary.
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/reservationSummary*")
public class ReservationSummaryController {

    private ReservationService reservationService;

    // Podłączanie usługi dostępnej w kontekście aplikacji 
    @Autowired
    public ReservationSummaryController(ReservationService reservationService) {
        this.reservationService = reservationService;
    }

    // Zauważ parametr date z ustawieniem required="true" w pierwszej metodzie.
    // Jeśli adres URL nie pasuje do wzorca /reservationSummary*?date=*, metoda nie zostanie wykonana.
    // UWAGA: Ponieważ jest do domyślna (i jedyna) metoda obsługi żądań GET,
    //        niepasujący adres (bez daty) powoduje zgłoszenie błędu 
    @RequestMapping(method = RequestMethod.GET)
	public String generateSummary(
	   @RequestParam(required = true, value = "date") String selectedDate, Model model) { 
	// Tworzenie pustej listy rezerwacji
	List<Reservation> reservations = java.util.Collections.emptyList();
	// Formatowanie daty
	try { 
	    Date summaryDate = new SimpleDateFormat("yyyy-MM-dd").parse(selectedDate);
	    reservations = reservationService.findByDate(summaryDate);
	    // Przechwytywanie błędu, jeśli parametr date ma niewłaściwy format
	} catch (java.text.ParseException ex) { 
	    // Zgłaszanie niestandardowego błędu.
	    // Zgodnie z exceptionMappings następuje przekierowanie do widoku reservationWebException, który
	    // jest wiązany z plikiem /WEB-INF/jsp/error.jsp
	    StringWriter sw = new StringWriter();
	    PrintWriter pw = new PrintWriter(sw);
	    ex.printStackTrace(pw); 
	    throw new ReservationWebException("Błędny format daty w podsumowaniu rezerwacji",new Date(),sw.toString());
	}
	// Po przekazaniu daty należy dodać rezerwacje (jeśli istnieją).
	// Należy dodać obiekt Reservations do modelu, aby można było wyświetlić go w widoku
	model.addAttribute("reservations",reservations);		
	// Sprawdzanie rozszerzenia z żądania
	/**
	if(request.getServletPath().endsWith(".pdf")) { 
	    // Rozszerzenie to .pdf.
	    // Należy zwrócić widok pdfSummary. Jest on wiązany z 
	    // klasą PdfReservationSummary
	    // zgodnie z plikiem views.properties
	    return "pdfSummary";
	} else if(request.getServletPath().endsWith(".xls")) { 
	    // Rozszerzenie to .xls.
	    // Należy zwrócić widok xlsSummary. Jest on wiązany
	    // z klasą ExcelReservationSummary
	    // zgodnie z plikiem views.properties
	    return "excelSummary";
	} else { 
	    // Dla innych rozszerzeń należy zwrócić widok reservationSummary.
	    // Jest on wiązany z plikiem /WEB-INF/jsp/reservationSummary.jsp
	    return "reservationSummary";
	    }*/
	return "reservationSummary";
    }
}
