// Wersja końcowa 
package com.apress.springrecipes.court.web;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

import com.apress.springrecipes.court.domain.PeriodicReservation;
import com.apress.springrecipes.court.domain.PeriodicReservationValidator;
import com.apress.springrecipes.court.domain.Player;
import com.apress.springrecipes.court.service.ReservationService;

import org.springframework.web.util.WebUtils;
import org.springframework.ui.Model;
import javax.servlet.http.HttpServletRequest; 
import javax.servlet.http.HttpServletResponse;


@Controller
// Wiązanie kontrolera z adresem URL /periodicReservationForm.
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/periodicReservationForm")
// Dodawanie do sesji obiektu typu Reservation, ponieważ jest używany w różnych stronach i formularzach
@SessionAttributes("reservation")
public class PeriodicReservationController {

    private ReservationService reservationService;
    private PeriodicReservationValidator validator;

    // Podłączanie usługi i walidatora w konstruktorze
    @Autowired
    public PeriodicReservationController(ReservationService reservationService,
             PeriodicReservationValidator periodicReservationValidator) {
        this.reservationService = reservationService;
	this.validator = periodicReservationValidator;
    }

    // Kontroler zawsze szuka domyślnej metody obsługi żądań GET (jej nazwa nie ma znaczenia).
    // Tu ta metoda nosi nazwę setupForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.GET)
    // Metoda przyjmuje parametr typu Model używany do ustawienia obiektu typu Reservation
    public String setupForm(Model model) {	
	// Tworzenie obiektu typu Reservation
        PeriodicReservation reservation = new PeriodicReservation();
	// Ustawianie gracza w tym obiekcie
        reservation.setPlayer(new Player());
	// Dodawanie rezerwacji do modelu, co pozwala wyświetlać ją w widokach
        model.addAttribute("reservation", reservation);
       	// Zwracanie łańcucha znaków z widokiem
	    // Na podstawie konfiguracji widok reservationCourtForm jest wiązany
	    // z plikiem JSP /WEB-INF/jsp/reservationCourtForm.jsp 
        return "reservationCourtForm";
    }

    // Kontroler zawsze szuka domyślnej metody obsługi żądań POST (nazwa nie ma tu znaczenia),
    // gdy zgłaszane jest żądanie danego adresu URL (@RequestMapping(/periodicReservationForm)).
    // Tu ta metoda nosi nazwę submitForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.POST)
    public String submitForm(
	    HttpServletRequest request, HttpServletResponse response,
            @ModelAttribute("reservation") PeriodicReservation reservation,
            BindingResult result, SessionStatus status,
	    @RequestParam("_page") int currentPage, Model model) {	
	// Definiowanie odwzorowania z numerami stron i widokami.
	// Jest ono używane, gdy użytkownik kliknie przycisk "Dalej" lub "Cofnij"
	// Widoki są wiązane z odpowiednimi stronami JSP z katalogu /WEB-INF/jsp/
	Map pageForms = new HashMap();
	pageForms.put(0,"reservationCourtForm");// Wiązany ze stroną /WEB-INF/jsp/reservationCourtForm.jsp
	pageForms.put(1,"reservationTimeForm");// Wiązany ze stroną /WEB-INF/jsp/reservationTimeForm.jsp
	pageForms.put(2,"reservationPlayerForm");// Wiązany ze stroną /WEB-INF/jsp/reservationPlayerForm.jsp
	// Sprawdzanie, czy użytkownik kliknął przycisk "Anuluj"
	if (request.getParameter("_cancel") != null) {
	    // Powrót do bieżącego widoku, ponieważ użytkownik kliknął "Anuluj"
	    return (String)pageForms.get(currentPage);	    
	// Sprawdzanie, czy użytkownik kliknął przycisk "Zakończ"
	} else if (request.getParameter("_finish") != null) {
	    // Użytkownik zakończył pracę. Nalezy sprawdzić rezerwację
	    new PeriodicReservationValidator().validate(reservation, result);
	    // Sprawdzanie wyniku pod kątem błędów po zakończeniu walidacji
	    if (!result.hasErrors()) {
		// Brak błędów w rezerwacji
		reservationService.makePeriodic(reservation);
		// Wywołanie setComplete() oznacza zakończenie przetwarzania sesji.
		// Można usunąć atrybuty sesji.
		status.setComplete();
		// Przekierowanie do adresu URL reservationSuccess z kontrolera ReservationSuccessController
		return "redirect:reservationSuccess";
	    } else {
		// Wystąpiły błędy. Zawsze powinno to się stać na stronie "reservationPlayerForm",
		// ponieważ jest ona ostatnia. Jednak i tak używane jest odwzorowanie HashMap.
		// Należy wyświetlić użytkownikowi bieżący widok i umożliwić wprowadzenie poprawek.
		return (String)pageForms.get(currentPage);	    
	    }
	// Użytkownik kliknął Dalej lub Cofnij (_target - różny od _cancel lub _finish)
	} else {
	    // Pobieranie docelowej strony
	    int targetPage = WebUtils.getTargetPage(request, "_target", currentPage);
	    // Jeśli targetPage ma wartość mniejszą niż na bieżącej stronie, użytkownik wybrał 'Cofnij' 
	    if (targetPage < currentPage) {
		// Powrót do docelowego widoku
		return (String)pageForms.get(targetPage);
	    } 
	    // Użytkownik kliknął 'Dalej'
	    // Sprawdzanie poprawności danych na podstawie strony
	    switch (currentPage) {
   	        case 0: 
		    new PeriodicReservationValidator().validateCourt(reservation, result); break;
	        case 1: 
		    new PeriodicReservationValidator().validateTime(reservation, result); break;
    	        case 2: 
		    new PeriodicReservationValidator().validatePlayer(reservation, result); break;
	    }
	    if (!result.hasErrors()) {
		// Brak błędów, należy zwrócić docelową stronę
		return (String)pageForms.get(targetPage);
	    } else { 
		// Wystąpiły błędy, należy zwrócić bieżącą stronę
		return (String)pageForms.get(currentPage);
	    }
	}
    }
    
    // Tworzenie atrybutu modelu. Ten atrybut będzie reprezentowany jako
    // lista rozwijana z wartościami "Codziennei, Co tydzień" w formularzu reservationTimeForm
    @ModelAttribute("periods")
    public Map<Integer, String> periods() {	
	Map<Integer, String> periods = new HashMap<Integer, String>();
	periods.put(1, "Codziennie");
	periods.put(7, "Co tydzień");
        return periods;
    }
}
