package com.apress.springrecipes.court.domain;

import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import org.springframework.stereotype.Component;

@Component
public class PeriodicReservationValidator implements Validator {

    public boolean supports(Class clazz) {
        return PeriodicReservation.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        validateCourt(target, errors);
        validateTime(target, errors);
        validatePlayer(target, errors);
    }

    public void validateCourt(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "courtName",
                "required.courtName", "Trzeba podać nazwę kortu.");
    }

    public void validateTime(Object target, Errors errors) {
        ValidationUtils.rejectIfEmpty(errors, "fromDate",
                "required.fromDate", "Trzeba podać datę początkową.");
        ValidationUtils.rejectIfEmpty(errors, "toDate", "required.toDate",
                "Trzeba podać datę końcową.");
        ValidationUtils.rejectIfEmpty(errors, "period",
                "required.period", "Trzeba podać okres.");
        ValidationUtils.rejectIfEmpty(errors, "hour", "required.hour",
                "Trzeba podać godzinę.");
    }

    public void validatePlayer(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "player.name",
                "required.playerName", "Trzeba podać nazwisko gracza.");
    }
}
