package com.apress.springrecipes.springbatch.solution2;

import com.apress.springrecipes.springbatch.UserRegistration;
import com.apress.springrecipes.springbatch.UserRegistrationService;

import org.apache.commons.lang.builder.ToStringBuilder;

import org.apache.log4j.Logger;

import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.support.RetryTemplate;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * Ta klasa rejestruje użytkownika za pomocą wywołania usługi RPC (jej interfejs kliencki jest 
 * podłączony za pomocą Springa).
 */
public class RetryableUserRegistrationServiceItemWriter implements ItemWriter<UserRegistration> {
    private static final Logger logger = Logger.getLogger(RetryableUserRegistrationServiceItemWriter.class);

    // Interfejs kliencki usługi opartej na technologii HTTP Invoker.
    @Autowired
    private UserRegistrationService userRegistrationService;
    
    @Autowired
    private RetryTemplate retryTemplate;

    /**
     * Przyjmuje zagregowane dane wejściowe z obiektu *Reader i 'zapisuje' je za pomocą niestandardowej implementacji.
     */
    public void write(List<?extends UserRegistration> items)
        throws Exception {
        for (final UserRegistration userRegistration : items) {
            UserRegistration registeredUserRegistration = retryTemplate.execute(new RetryCallback<UserRegistration>() {
                        public UserRegistration doWithRetry(RetryContext context)
                            throws Exception {
                            return userRegistrationService.registerUser(userRegistration);
                        }
                    });

            logger.debug("Zarejestrowano:" + ToStringBuilder.reflectionToString(registeredUserRegistration));
        }
    }
}
