// Wersja końcowa 
package com.apress.springrecipes.court.web;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Date;


@Controller
// Wiązanie kontrolera z adresem URL /welcome
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/welcome")
public class WelcomeController {
	// Kontroler zawsze najpierw szuka domyślnej metody obsługi żądań GET (niezależnie od jej nazwy).
	// Tu ta metoda to welcome, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.GET)
	// Metoda przyjmuje parametr Model, aby ustawić datę
	// UWAGA: Model to interfejs z Javy 5 (nowszy od klas ModelMap i ModelAndView)
    public String welcome(Model model) {
        Date today = new Date();
		// Dodawanie daty do modelu, aby można ją było wyświetlić w widoku
        model.addAttribute("today", today);

		// Zwracanie widoku welcome. Jest on wiązany
		// z plikiem /WEB-INF/jsp/welcome.jsp
        return "welcome";
    }
}
