package com.apress.springrecipes.court.web;

import com.apress.springrecipes.court.domain.FeedContent;

import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Controller;

import org.springframework.ui.Model;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.client.RestTemplate;

import org.springframework.xml.xpath.NodeMapper;

import org.w3c.dom.*;

import org.xml.sax.InputSource;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;


@Controller
public class RestNewsController {
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected org.springframework.xml.xpath.XPathExpression feeditemExpression;
    @Autowired
    protected org.springframework.xml.xpath.XPathExpression feedtitleExpression;
    @Autowired
    protected org.springframework.xml.xpath.XPathExpression feedlinkExpression;
    @Autowired
    protected org.springframework.xml.xpath.AbstractXPathTemplate feedXPathTemplate;

    @RequestMapping("/sportsnews")
    public String getYahooNews(Model model) {
        // Zwracanie widoku newstemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/newstemplate.jsp
        String result = restTemplate.getForObject("http://search.yahooapis.com/NewsSearchService/V1/newsSearch?appid={appid}&query={query}&results={results}&language={language}", String.class,
                "YahooDemo", "sports", "2", "en");
        model.addAttribute("newsfeed", result);

        return "newstemplate";
    }

    @RequestMapping("/nationalweather")
    public String getWeatherNews(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        try {
            StreamSource source = restTemplate.getForObject("http://rss.weather.com/rss/national/rss_nwf_rss.xml?cm_ven={cm_ven}&cm_cat={cm_cat}&par={par}", StreamSource.class, "NWF", "rss", "NWF_rss");

            // Definiowanie obiektu DocumentBuilderFactory
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);

            // Definiowanie obiektu DocumentBuilder
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();

            // Definiowanie obiektu InputSource
            InputSource is = new InputSource();
            is.setSystemId(source.getSystemId());
            is.setByteStream(source.getInputStream());
            is.setCharacterStream(source.getReader());
            is.setEncoding("ISO-8859-1");

            // Definiowanie obiektu Document 
            Document doc = db.parse(is);

            // Pobieranie elementów
            NodeList itemElements = doc.getElementsByTagName("item");

            // Definiowanie list tytułów i odnośników
            List<String> feedtitles = new ArrayList<String>();
            List<String> feedlinks = new ArrayList<String>();

            // Przechodzenie w pętli po wszystkich elementach
            int length = itemElements.getLength();

            for (int n = 0; n < length; ++n) {
                NodeList childElements = itemElements.item(n).getChildNodes();
                int lengthnested = childElements.getLength();

                for (int k = 0; k < lengthnested; ++k) {
                    if (childElements.item(k).getNodeName().equals("title")) {
                        feedtitles.add(childElements.item(k).getChildNodes().item(0).getNodeValue());
                    }

                    if (childElements.item(k).getNodeName().equals("link")) {
                        feedlinks.add(childElements.item(k).getChildNodes().item(0).getNodeValue());
                    }
                }
            }

            // Lista z treścią
            List<FeedContent> feedcontent = new ArrayList<FeedContent>();
            int titlelength = feedtitles.size();

            // Przechodzenie w pętli po pobranych tytułach i odnośnikach
            for (int x = 0; x < titlelength; ++x) {
                feedcontent.add(new FeedContent(feedtitles.get(x), feedlinks.get(x)));
            }

			// Dodawanie typu, wersji i treści kanału do obiektu model
            model.addAttribute("feedtype", doc.getDocumentElement().getNodeName());
            model.addAttribute("feedversion", doc.getDocumentElement().getAttribute("version"));
            model.addAttribute("feedcontent", feedcontent);
        } catch (Exception exc) {
            System.out.println(exc);
        }

        return "nationalweathertemplate";
    }

    @RequestMapping("/nationalweather2")
    public String getWeatherNews2(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        try {
            StreamSource source = restTemplate.getForObject("http://rss.weather.com/rss/national/rss_nwf_rss.xml?cm_ven={cm_ven}&cm_cat={cm_cat}&par={par}", StreamSource.class, "NWF", "rss", "NWF_rss");

            // Definiowanie obiektu DocumentBuilderFactory
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);

            // Definiowanie obiektu DocumentBuilder
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();

            // Definiowanie obiektu InputSource
            InputSource is = new InputSource();
            is.setSystemId(source.getSystemId());
            is.setByteStream(source.getInputStream());
            is.setCharacterStream(source.getReader());
            is.setEncoding("ISO-8859-1");

            // Definiowanie obiektu Document 
            Document doc = db.parse(is);

            // Definiowanie list na tytuły i odnośniki
            List feedtitles = new ArrayList();
            List feedlinks = new ArrayList();

            // Definiowanie obiektów XPath
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();

            // Definiowanie wyrażenia XPath do pobierania tytułów								
            XPathExpression titleexpr = xpath.compile("//item/title");

            // Definiowanie wyrażenia XPath do pobierania odnośników
            XPathExpression linkexpr = xpath.compile("//item/link");

            // Przetwarzanie wyrażeń XPath
            Object titleresult = titleexpr.evaluate(doc, XPathConstants.NODESET);
            Object linkresult = linkexpr.evaluate(doc, XPathConstants.NODESET);

            // Przejście w pętli po pobranych tytułach za pomocą modelu DOM
            NodeList titlenodes = (NodeList) titleresult;

            for (int i = 0; i < titlenodes.getLength(); i++) {
                feedtitles.add(titlenodes.item(i).getChildNodes().item(0).getNodeValue());
            }

            // Przejście w pętli po pobranych odnośnikach za pomocą modelu DOM	    
            NodeList linknodes = (NodeList) linkresult;

            for (int j = 0; j < linknodes.getLength(); j++) {
                feedlinks.add(linknodes.item(j).getChildNodes().item(0).getNodeValue());
            }

            // Lista na treść 
            List feedcontent = new ArrayList();
            int titlelength = feedtitles.size();

            // Przejście w pętli po pobranych tytułach i odnośnikach
            for (int x = 0; x < titlelength; ++x) {
                feedcontent.add(new FeedContent((String) feedtitles.get(x), (String) feedlinks.get(x)));
            }

            // Dodanie typu, wersji i treści kanału do obiektu model
            model.addAttribute("feedtype", doc.getDocumentElement().getNodeName());
            model.addAttribute("feedversion", doc.getDocumentElement().getAttribute("version"));
            model.addAttribute("feedcontent", feedcontent);
        } catch (Exception exc) {
            System.out.println(exc);
        }

        return "nationalweathertemplate";
    }

    @RequestMapping("/nationalweather3")
    public String getWeatherNews3(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        try {
            StreamSource source = restTemplate.getForObject("http://rss.weather.com/rss/national/rss_nwf_rss.xml?cm_ven={cm_ven}&cm_cat={cm_cat}&par={par}", StreamSource.class, "NWF", "rss", "NWF_rss");

            // Definiowanie obiektu DocumentBuilderFactory
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);

            // Definiowanie obiektu DocumentBuilder
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();

            // Definiowanie obiektu InputSource
            InputSource is = new InputSource();
            is.setSystemId(source.getSystemId());
            is.setByteStream(source.getInputStream());
            is.setCharacterStream(source.getReader());
            is.setEncoding("ISO-8859-1");

            // Definiowanie obiektu Document 
            Document doc = db.parse(is);

            // Definiowanie list na tytuły i odnośniki
            List feedtitles = new ArrayList();
            List feedlinks = new ArrayList();

            List<Node> titlenodes = feedtitleExpression.evaluateAsNodeList(doc.getDocumentElement());
            List<Node> linknodes = feedlinkExpression.evaluateAsNodeList(doc.getDocumentElement());

            for (Node node : titlenodes) {
                feedtitles.add(node.getChildNodes().item(0).getNodeValue());
            }

            for (Node node : linknodes) {
                feedlinks.add(node.getChildNodes().item(0).getNodeValue());
            }

            // Lista na treść  
            List feedcontent = new ArrayList();
            int titlelength = feedtitles.size();

            // Przejście w pętli po pobranych tytułach i odnośnikach
            for (int x = 0; x < titlelength; ++x) {
                feedcontent.add(new FeedContent((String) feedtitles.get(x), (String) feedlinks.get(x)));
            }

            // Dodanie typu, wersji i treści kanału do obiektu model
            model.addAttribute("feedtype", doc.getDocumentElement().getNodeName());
            model.addAttribute("feedversion", doc.getDocumentElement().getAttribute("version"));
            model.addAttribute("feedcontent", feedcontent);
        } catch (Exception exc) {
            System.out.println(exc);
        }

        return "nationalweathertemplate";
    }

    @RequestMapping("/nationalweather4")
    public String getWeatherNews4(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        try {
            StreamSource source = restTemplate.getForObject("http://rss.weather.com/rss/national/rss_nwf_rss.xml?cm_ven={cm_ven}&cm_cat={cm_cat}&par={par}", StreamSource.class, "NWF", "rss", "NWF_rss");

            // Definiowanie obiektu DocumentBuilderFactory
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);

            // Definiowanie obiektu DocumentBuilder
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();

            // Definiowanie obiektu InputSource
            InputSource is = new InputSource();
            is.setSystemId(source.getSystemId());
            is.setByteStream(source.getInputStream());
            is.setCharacterStream(source.getReader());
            is.setEncoding("ISO-8859-1");

            // Definiowanie obiektu Document 
            Document doc = db.parse(is);

            // Definiowanie list na tytuły i odnośniki
            List feedtitles = new ArrayList();
            List feedlinks = new ArrayList();

            List feedcontent = feeditemExpression.evaluate(doc,
                    new NodeMapper() {
                        public Object mapNode(Node node, int nodeNum)
                            throws DOMException {
                            Element itemElement = (Element) node;
                            Element titleElement = (Element) itemElement.getElementsByTagName("title").item(0);
                            Element linkElement = (Element) itemElement.getElementsByTagName("link").item(0);

                            return new FeedContent(titleElement.getTextContent(), linkElement.getTextContent());
                        }
                    });

            // Dodanie typu, wersji i treści kanału do obiektu model
            model.addAttribute("feedtype", doc.getDocumentElement().getNodeName());
            model.addAttribute("feedversion", doc.getDocumentElement().getAttribute("version"));
            model.addAttribute("feedcontent", feedcontent);
        } catch (Exception exc) {
            System.out.println(exc);
        }

        return "nationalweathertemplate";
    }

    @RequestMapping("/nationalweather5")
    public String getWeatherNews5(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        try {
            Source source = restTemplate.getForObject("http://rss.weather.com/rss/national/rss_nwf_rss.xml?cm_ven={cm_ven}&cm_cat={cm_cat}&par={par}", Source.class, "NWF", "rss", "NWF_rss");

            // Definiowanie list na tytuły i odnośniki
            List feedtitles = new ArrayList();
            List feedlinks = new ArrayList();

            List feedcontent = feedXPathTemplate.evaluate("//item", source,
                    new NodeMapper() {
                        public Object mapNode(Node node, int nodeNum)
                            throws DOMException {
                            Element itemElement = (Element) node;
                            Element titleElement = (Element) itemElement.getElementsByTagName("title").item(0);
                            Element linkElement = (Element) itemElement.getElementsByTagName("link").item(0);

                            return new FeedContent(titleElement.getTextContent(), linkElement.getTextContent());
                        }
                    });

            // Bez obiektu Document - tylko zapisane na stałe typ i wersja kanału
            model.addAttribute("feedtype", "rss");
            model.addAttribute("feedversion", "2.0");
            // Dodawanie treści (feedcontent) pobranej za pomocą szablonu XPathTemplate
            model.addAttribute("feedcontent", feedcontent);
        } catch (Exception exc) {
            System.out.println(exc);
        }

        return "nationalweathertemplate";
    }

    @RequestMapping("/worldnews")
    public String getGoogleNews(Model model) {
        // Zwracanie widoku nationalweathertemplate. Jest on wiązany z plikiem
        // /WEB-INF/jsp/nationalweathertemplate.jsp
        // GOOGLE BLOKUJE ŻĄDANIA
        String result = restTemplate.getForObject("http://news.google.com/news?ned={ned}&topic={topic}&output={output}", String.class, "us", "w", "rss");
        model.addAttribute("worldnewsfeed", result);

        return "worldnewstemplate";
    }
}
