package com.apress.springrecipes.replicator;

import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.notification.NotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;

import java.io.File;
import java.io.IOException;

import javax.management.Notification;


@ManagedResource(description = "Kopiowanie plików")
public class FileReplicatorJMXImpl implements FileReplicator, NotificationPublisherAware {
    private String srcDir;
    private String destDir;
    private FileCopier fileCopier;
    private int sequenceNumber;
    private NotificationPublisher notificationPublisher;

    @ManagedAttribute(description = "Pobieranie katalogu źródłowego")
    public String getSrcDir() {
        return srcDir;
    }

    @ManagedAttribute(description = "Ustawianie katalogu źródłowego")
    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    @ManagedAttribute(description = "Pobieranie katalogu docelowego")
    public String getDestDir() {
        return destDir;
    }

    @ManagedAttribute(description = "Ustawianie katalogu docelowego")
    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public void setFileCopier(FileCopier fileCopier) {
        this.fileCopier = fileCopier;
    }

    public void setNotificationPublisher(NotificationPublisher notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }

    @ManagedOperation(description = "Powielanie plików")
    public synchronized void replicate() throws IOException {
        notificationPublisher.sendNotification(new Notification("replication.start", this, sequenceNumber));

        File[] files = new File(srcDir).listFiles();

        for (File file : files) {
            if (file.isFile()) {
                fileCopier.copyFile(srcDir, destDir, file.getName());
            }
        }

        notificationPublisher.sendNotification(new Notification("replication.complete", this, sequenceNumber));
        sequenceNumber++;
    }
}
