package com.apress.springrecipes.springintegration;

import org.springframework.integration.annotation.Router;


public class CustomerCreditScoreRouter {
    @Router
    public String routeByCustomerCreditScore(Customer customer) {
        if (customer.getCreditScore() > 770) {
            System.out.println("Ocena zdolności kredytowej > 770. Przekierowanie do kanału safeCustomerChannel");

            return "safeCustomerChannel";
        } else {
            System.out.println("Ocena zdolności kredytowej <= 770. Przekierowanie do kanału riskyCustomerChannel");

            return "riskyCustomerChannel";
        }
    }
}
