package com.apress.springrecipes.court.domain;

import java.util.Calendar;
import java.util.Date;

import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import org.springframework.stereotype.Component;

@Component
public class ReservationValidator implements Validator {

    public boolean supports(Class clazz) {
        return Reservation.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "courtName",
                "required.courtName", "Trzeba podać nazwę kortu.");
        ValidationUtils.rejectIfEmpty(errors, "date",
                "required.date", "Trzeba podać datę.");
        ValidationUtils.rejectIfEmpty(errors, "hour",
                "required.hour", "Trzeba podać godzinę.");
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "player.name",
                "required.playerName", "Trzeba podać nazwisko gracza.");
        ValidationUtils.rejectIfEmpty(errors, "sportType",
                "required.sportType", "Trzeba podać typ sportu.");

        Reservation reservation = (Reservation) target;
        Date date = reservation.getDate();
        int hour = reservation.getHour();
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (calendar.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                if (hour < 8 || hour > 22) {
                    errors.reject("invalid.holidayHour", "Błędna godzina w dzień wolny.");
                }
            } else {
                if (hour < 9 || hour > 21) {
                    errors.reject("invalid.weekdayHour", "Błędna godzina w dzień roboczy.");
                }
            }
        }
    }
}
