package com.apress.springrecipes.replicator;

import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

import org.springframework.util.FileCopyUtils;

import java.io.File;
import java.io.IOException;


@ManagedResource(objectName = "bean:name=fileCopier,type=FileCopierImpl", description = "Kopiowanie plików")
public class FileCopierJMXImpl implements FileCopier {
    @ManagedOperation(description = "Kopiuje plik z katalogu źródłowego do docelowego")
    @ManagedOperationParameters({@ManagedOperationParameter(name = "srcDir", description = "Katalog źródłowy")
        , @ManagedOperationParameter(name = "destDir", description = "Katalog docelowy")
        , @ManagedOperationParameter(name = "filename", description = "Kopiowany plik")
    })
    public void copyFile(String srcDir, String destDir, String filename)
        throws IOException {
        File srcFile = new File(srcDir, filename);
        File destFile = new File(destDir, filename);
        FileCopyUtils.copy(srcFile, destFile);
    }
}
