package com.apress.springrecipes.replicator;

import org.springframework.core.io.ClassPathResource;

import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

import javax.mail.internet.MimeMessage;


public class EmailErrorNotifier implements ErrorNotifier {
    private JavaMailSender mailSender;
    private SimpleMailMessage copyErrorMailMessage;

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setCopyErrorMailMessage(SimpleMailMessage copyErrorMailMessage) {
        this.copyErrorMailMessage = copyErrorMailMessage;
    }

    public void notifyCopyError(final String srcDir, final String destDir, final String filename) {
        MimeMessagePreparator preparator = new MimeMessagePreparator() {
                public void prepare(MimeMessage mimeMessage)
                    throws Exception {
                    MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
                    helper.setFrom(copyErrorMailMessage.getFrom());
                    helper.setTo(copyErrorMailMessage.getTo());
                    helper.setSubject(copyErrorMailMessage.getSubject());
                    helper.setText(String.format(copyErrorMailMessage.getText(), srcDir, destDir, filename));

                    ClassPathResource config = new ClassPathResource("beans.xml");
                    helper.addAttachment("beans.xml", config);
                }
            };

        mailSender.send(preparator);
    }
}
