/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.searchpolicy.CandidateSet;
import org.apache.felix.framework.searchpolicy.PackageSource;

class ResolvedPackage {
    public final String m_name;
    public final CandidateSet m_cs;
    public final List m_sourceList = new ArrayList();

    public ResolvedPackage(String name, CandidateSet cs) {
        this.m_name = name;
        this.m_cs = cs;
    }

    public boolean isSubset(ResolvedPackage rp) {
        if (this.m_sourceList.size() > rp.m_sourceList.size()) {
            return false;
        }
        if (!this.m_name.equals(rp.m_name)) {
            return false;
        }
        return rp.m_sourceList.containsAll(this.m_sourceList);
    }

    public Object clone() {
        ResolvedPackage rp = new ResolvedPackage(this.m_name, this.m_cs);
        rp.m_sourceList.addAll(this.m_sourceList);
        return rp;
    }

    public void merge(ResolvedPackage rp) {
        for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
            if (this.m_sourceList.contains(rp.m_sourceList.get(srcIdx))) continue;
            this.m_sourceList.add(rp.m_sourceList.get(srcIdx));
        }
    }

    public String toString() {
        return this.toString("", new StringBuffer()).toString();
    }

    public StringBuffer toString(String padding, StringBuffer sb) {
        sb.append(padding);
        sb.append(this.m_name);
        sb.append(" from [");
        for (int i = 0; i < this.m_sourceList.size(); ++i) {
            PackageSource ps = (PackageSource)this.m_sourceList.get(i);
            sb.append(ps.m_module);
            if (i + 1 >= this.m_sourceList.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb;
    }
}

