/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.Util;
import org.apache.felix.main.AutoActivator;
import org.osgi.framework.launch.Framework;

public class Main {
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    private static Framework m_felix = null;

    public static void main(String[] args) throws Exception {
        if (args.length > 1) {
            System.out.println("Usage: [<bundle-cache-dir>]");
            System.exit(0);
        }
        Main.loadSystemProperties();
        Properties configProps = Main.loadConfigProperties();
        if (configProps == null) {
            System.err.println("No config.properties found.");
            configProps = new Properties();
        }
        Main.copySystemProperties(configProps);
        if (args.length > 0) {
            configProps.setProperty("org.osgi.framework.storage", args[0]);
        }
        ArrayList<AutoActivator> list = new ArrayList<AutoActivator>();
        list.add(new AutoActivator(configProps));
        configProps.put("felix.systembundle.activators", list);
        System.out.println("\nWelcome to Felix.");
        System.out.println("=================\n");
        try {
            m_felix = new Felix(configProps);
            m_felix.start();
            m_felix.waitForStop(0L);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public static void loadSystemProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(SYSTEM_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, SYSTEM_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Util.substVars(props.getProperty(name), name, null, null));
        }
    }

    public static Properties loadConfigProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(CONFIG_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return null;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, CONFIG_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (Exception ex) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Util.substVars(props.getProperty(name), name, null, props));
        }
        return props;
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }
}

