/* 
 * Copyright 2011-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.springinpractice.ch11.service.impl;

import static org.mockito.Matchers.anyLong;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Iterator;

import org.junit.Before;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.repository.GraphRepository;

import com.springinpractice.ch11.model.Farm;
import com.springinpractice.ch11.model.Instance;
import com.springinpractice.ch11.repository.FarmRepository;
import com.springinpractice.ch11.service.impl.AbstractCIService;
import com.springinpractice.ch11.service.impl.FarmServiceImpl;

/**
 * @author Willie Wheeler (willie.wheeler@gmail.com)
 */
public class FarmServiceImplTests extends AbstractEntityServiceImplTests<Farm> {
	@InjectMocks private FarmServiceImpl farmService;
	@Mock private FarmRepository farmRepository;
	
	// Test objects
	@Mock private Farm farm;
	@Mock private ClosableIterable<Farm> farms;
	@Mock private Iterator<Farm> farmIterator;

	/* (non-Javadoc)
	 * @see com.springinpractice.ch11.service.impl.AbstractEntityServiceImplTests#getRepository()
	 */
	@Override
	protected GraphRepository<Farm> getRepository() { return farmRepository; }
	
	/* (non-Javadoc)
	 * @see com.springinpractice.ch11.service.impl.AbstractEntityServiceImplTests#getService()
	 */
	@Override
	public AbstractCIService<Farm> getService() { return farmService; }
	
	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		this.farmService = new FarmServiceImpl();
		
		MockitoAnnotations.initMocks(this);
		
		when(farmRepository.findOne(anyLong())).thenReturn(farm);
		when(farmRepository.findAll()).thenReturn(farms);
		when(farm.getInstances()).thenReturn(new ArrayList<Instance>());
		when(farms.iterator()).thenReturn(farmIterator);
	}
}
