/*
  Stinger player
  Kontekst: Arduino
*/

#include <SoftwareSerial.h>
// skonfiguruj port SoftwareSerial do wysyłania MIDI:
SoftwareSerial midi(2, 3);

const int midiResetPin = 4;  // pin resetu tarczy Musical Instrument
const int threshold = 100;   // próg czujnika
int lastReading = 0;         // ostatni odczyt czujnika

void setup() {
  // zainicjuj sprzętowy port szeregowy i port szeregowy MIDI:
  Serial.begin(9600);
  midi.begin(31250);

  // resetuj tarczę instrumentu muzycznego:
  resetMidi(midiResetPin);
}

void loop() {
  // odczyt czujnika:
  int sensorReading = analogRead(A0);
  Serial.println(sensorReading);

  // jeżeli odczyt czujnika jest wyższy niż próg 
  // i był niższy niż próg ostatnim razem, 
  // odtwórz stinger:
  if (sensorReading <= threshold
    && lastReading > threshold ) {
     playStinger();
  }
  // zapisz bieżący odczyt do następnego razu:
  lastReading = sensorReading;

}

void playStinger() {
  int note[] = {43, 41, 49};
  int rest[] = {70, 180, 750};

  // pętla przez trzy nuty:
  for (int thisNote = 0; thisNote < 3; thisNote++) {
    // włącz nutę:
    noteOn(9, note[thisNote], 60);
    delay(rest[thisNote]);
    // wyłącz nutę:
    noteOff(9, note[thisNote], 60);
    // mała pauza po drugiej nucie:
    if (thisNote == 1) {
      delay(50);
    }
  }
}


// wyślij komunikat MIDI note-on. 
// To jak naciśnięcie klawisza pianina.
// Kanał ma zakres 0–15
void noteOn(byte channel, byte note, byte velocity) {
  sendMidi( (0x90 | channel), note, velocity);
}

// wyślij wiadomość MIDI  note-off. 
// To jak jak zwalnianie klawisza pianina
void noteOff(byte channel, byte note, byte velocity) {
  sendMidi( (0x80 | channel), note, velocity);
}

void resetMidi(int thisPin) {
  // reset tarczy Musical Instrument:
  pinMode(thisPin, OUTPUT);
  digitalWrite(thisPin, LOW);
  delay(100);
  digitalWrite(thisPin, HIGH);
  delay(100);
}

void sendMidi(byte cmd, byte data1, byte data2) {
  // wyślij komunikat MIDI:
  midi.write(cmd);
  midi.write(data1);
  midi.write(data2);
}

