/*
  Wykrywanie twarzy za pomocą OpenCV
  Kontekst: Processing
*/

// importuj biblioteki opencv i Rectangle:
import hypermedia.video.*;
import java.awt.Rectangle;

OpenCV opencv;   // nowa instancja biblioteki openCV

void setup() {
  // inicjacja okna:
  size( 320,240 );
  // inicjacja opencv:
  opencv = new OpenCV( this );
  opencv.capture( width, height );
  // wybierz używany opis wykrywania:
  opencv.cascade( OpenCV.CASCADE_FRONTALFACE_DEFAULT );
  // rysuj gładkie krawędzie:
  smooth();
  // ustaw rysowanie elipsy od lewego górnego rogu:
  ellipseMode(CORNER);
}


void draw() {
  // przechwyć nową ramkę:
  opencv.read();

  // wyszukaj twarze:
  Rectangle[] faces = opencv.detect();

  //wyświetl obraz:
  image( opencv.image(), 0, 0 );

  // narysuj okręgi wokół twarzy:
  fill(0xFF, 0x00, 0x84, 0x3F); // miły odcień fuksji 
  noStroke();                   // bez obramowania 

  for ( int thisFace=0; thisFace<faces.length; thisFace++ ) {
    ellipse( faces[thisFace].x, faces[thisFace].y,
      faces[thisFace].width, faces[thisFace].height );
  }
}


