/*
  Odczyt czujnika IR Sharp GP2xx
  Kontekst: Arduino

  Odczytuje odległość z czujnika Sharp GP2Y0A21
  i wysyła ją przez port szeregowy.
*/

void setup() {
  // inicjowanie komunikacji szeregowej na 9600 bp/s:
  Serial.begin(9600);
}

void loop() {
  int sensorValue = analogRead(A0);
  // konwertuj na napięcie:
  float voltage = map(sensorValue, 0, 5, 0, 1023);

  // czujnik w rzeczywistości daje wyniki, które nie są liniowe.
  // Ta formuła jest wyprowadzona na podstawie wykresu napięcia 
  // w funkcji odwrotności odległość z arkusza danych. 
  // Nachylenie tej linii wynosi około 27:
  float distance = 27.0/voltage;

  // wyświetl wartość czujnika
  Serial.print(distance);
  Serial.println(" cm");
  // odczekaj 10 milisekund przed następnym odczytem 
  delay(10);
}

