/*
  Nadawca/odbiorca skierowanych lub rozgłaszanych kwerend UDP 
  Kontekst: Processing
*/

// import biblioteki UDP:
import hypermedia.net.*;

UDP udp;                      // inicjacja obiektu UDP 

void setup() {
  udp = new UDP(this, 43770); // otwórz port UDP 
  udp.listen(true);           // nasłuchiwanie wiadomości przychodzących 
}

void draw()
{
}


void keyPressed() {
  int port = 43770;                        // port docelowy
  String message = ", mówię do CIEBIE!";   // wiadomość do wysłania 
  String ip = "255.255.255.255";           // zdalny adres IP 

// wyślij do różnych adresatów  w zależności od naciśniętego klawisza:
switch (key) {
  case 'a':                // zapytanie rozgłaszane
    message = "Wzywam wszystkie kaczki!\n";
    break;
  case 'b':                 // zapytanie ukierunkowane
    ip = "192.168.1.20";    // zdalny adres IP 
    message = ip + message; // wiadomość do wysłania 
    break;
  case 'c':                 // bezpośrednie kwerendy 
    ip = "192.168.1.30";    // zdalny adres IP 
    message = ip + message; // wiadomość do wysłania 
    break;
  }

  // wyślij wiadomość dona wybranego y adresu :
  udp.send(message, ip, port );
}


void receive( byte[] data ) {
  // wyświetl przychodzące bajty danych jako znaki ASCII :
  for(int thisChar=0; thisChar < data.length; thisChar++) {
    print(char(data[thisChar]));
  }
  println();
}
