/*
  Serwer Pong
  Kontekst:  Processing
 
  Ten program nasłuchuje połączeń TCP i używa danych
  z przychodzących połączeń w sieciowej wieloosobowej
  wersji ponga.
 
  Wersja 0002 poprawia błąd ze zmienną delayCounter który zatrzymywał początkową grę
 
  Zmodyfikowany 24 Sty 2011
  przez Toma Igoe
 
 */

// dołącz bibliotekę sieciową:
import processing.net.*;

// zmienne niezbędne do śledzenia klientów:
int port = 8080;              // port, na którym nasłuchuje serwer
Server myServer;              // obiekt serwera 
ArrayList playerList = new ArrayList(); // lista klientów

// zmienne do niezbędne do śledzenia przebiegu gry i grafiki:
int ballSize = 10;             // rozmiar piłki
int ballDirectionV = 2;        // kierunek poziomy piłki
                               // liczba ujemna to lewo, 
                               / dodatnia - prawo
int ballDirectionH = 2;        // kierunek pionowy piłki
                               // liczba ujemna to góra, dodatnia - dół
int ballPosV, ballPosH;        // pozycja pozioma i pionowa piłki
boolean ballInMotion = false;  // czy piłka powinna się poruszać?

int topScore, bottomScore;     // wyniki dla zespołu u góry 
                               // i zespołu u dołu 
int paddleHeight = 10;         // wymiar pionowy rakietki 
int paddleWidth = 80;          // wymiar poziomy rakietki 
int nextTopPaddleV;            // pozycja rakietki następnego gracza, 
                               // który zostanie dołączaony 
int nextBottomPaddleV;

boolean gameOver = false;      // czy gra jest w toku? 
long delayCounter;             // licznik opóźnienia na
                               // koniec gry
long gameOverDelay = 4000;     // przerwa po każdej grze 
long pointDelay = 2000;        // przerwa po każdym punkcie

void setup() {
   // ustaw rozmiar okna:
   size(480, 640);
   // ustaw częstotliwość odświeżania ekranu:
   frameRate(90);
   // ustaw domyślne wyrównanie czcionki:
   textAlign(CENTER);
   // ustaw brak ramek dla rysowanych kształtów:
   noStroke();
   // ustaw rectMode tak, aby wszystkie wymiary prostokątów 
   // podawane były względem centrum prostokąta 
   // (zobacz w dokumentacji Processing):
   rectMode(CENTER);

   // skonfiguruj wszystkie szczegóły pPong:
   // zainicjuj licznik opóźnienia:
   delayCounter = millis();
   // zainicjuj pozycję rakietki pierwszego gracza.
   // te wartości będą zwiększane z każdym nowym graczem:
   nextTopPaddleV = 50;
   nextBottomPaddleV = height - 50;

   // zainicjuj piłkę na środku ekranu:
   ballPosV = height / 2;
   ballPosH = width / 2;

   // uruchom serwer:
   myServer = new Server(this, port);
}

void draw() {
   drawGame();
   listenToClients();
}

// komunikat ServerEvent jest generowany, kiedy nowy klient
// nawiązuje połączenie z serwerem.
void serverEvent(Server thisServer, Client thisClient) {
  if (thisClient != null) {
    // iteracyjnie przeglądaj listę playerList:
    for (int p = 0; p < playerList.size(); p++) {
       // weź następny obiekt na liście ArrayList 
       // i przekonwertuj go na Player:
      Player newPlayer = (Player)playerList.get(p);

      // jeśli klient thisPlayer odpowiada temu, który generuje
      // serverEvent, wtedy ten klient jest już graczem, 
      // więc zakończ metodę i wróć:
      if (newPlayer.client == thisClient) {
        return;
      }
    }

    // jeśli klient nie jest graczem, to stwórz nowego gracza 
    // i dodaj go do playerList:
    makeNewPlayer(thisClient);
  }
}

void makeNewPlayer(Client thisClient) {
   // pozycja rakietki nowego gracza:
   int x = width/2;
   // jeśli nie ma graczy, dodaj u góry:
   int y = nextTopPaddleV;

   /*
   Pobierz pozycję rakietki ostatniego gracza na liście.
    Jeśli jest na górze, dodaj nowego gracza na spodzie, i odwrotnie.
    Jeśli nie ma żadnego gracza, dodaj nowego gracza na górze.
   */
   // pobierz rozmiar listy:
   int listSize = playerList.size() - 1;
   // jeśli istnieją inni gracze:
   if (listSize >= 0) {
      // pobierz ostatniego gracza na liście:
      Player lastPlayerAdded = (Player)playerList.get(listSize);
      // jest ostatni gracz jest na górze, dodaj na dole:
      if (lastPlayerAdded.paddleV == nextTopPaddleV) {
         nextBottomPaddleV = nextBottomPaddleV - paddleHeight * 2;
         y = nextBottomPaddleV;
      }
      // jeśli ostatni gracz jest na dole, dodaj na górze:
      else if (lastPlayerAdded.paddleV == nextBottomPaddleV) {
         nextTopPaddleV = nextTopPaddleV + paddleHeight * 2;
         y = nextTopPaddleV;
      }
   }
   // utwórz nowy obiekt Player na pozycji, którą właśnie obliczyłeś,
   // i użyj klienta, który wygenerował serverEvent:
   Player newPlayer = new Player(x, y, thisClient);
   // dodaj nowego gracza do listy graczy:
   playerList.add(newPlayer);
   // zaanonsuj nowego gracza:
   println("Mamy nowego gracza: " + newPlayer.client.ip());
   newPlayer.client.write("hi\r\n");
}

void listenToClients() {
   // pobierz następnego klienta, który wysyła wiadomości:
   Client speakingClient = myServer.available();
   Player speakingPlayer = null;

   // iteracyjnie przeglądaj listę graczy, aby sprawdzić, 
   // który klient wysłał wiadomość:
   for (int p = 0; p < playerList.size(); p++) {
      // pobierz następny obiekt z listy ArrayList 
      // i przekonwertuj go na gracza Player:
      Player thisPlayer = (Player)playerList.get(p);
      // porównaj klienta thisPlayer  z klientaem, 
      // który wysłał wiadomość. Jeśli to ten sam, 
      // to jest to Player, którego szukamy:
      if (thisPlayer.client == speakingClient) {
         speakingPlayer = thisPlayer;
         break;
      }
   }
   // przeczytaj, co przysłał klient:
   if (speakingPlayer != null) {
      int whatClientSaid = speakingPlayer.client.read();
      /*
      Kilka rzeczy, które mógł wypowiedzieć, które nas interesująe:
      x = wyjście
      l = ruch w lewo
      p = ruch w prawo
      */
      switch (whatClientSaid) {
         // jeśli klient mówi "wyjście", odłącz go 
         case 'x':
            // pożegnaj się z klientem:
            speakingPlayer.client.write("papa\r\n");
            // odłącz klienta od serwera:
            println(speakingPlayer.client.ip() + "\t wylogowany");
            myServer.disconnect(speakingPlayer.client);
            // usuń klienta Player z listy graczy:
            playerList.remove(speakingPlayer);
            break;
         case 'l':
            // jeśli klient wysyła "l", przemieść rakietkę w lewo
            speakingPlayer.movePaddle(-10);
            break;
         case 'p':
            // jeśli klient wysyła "p", przemieść rakietkę w prawo 
            speakingPlayer.movePaddle(10);
            break;
      }
   }
}

void drawGame() {
   background(0);
   // rysuj wszystkie rakietki
   for (int p = 0; p < playerList.size(); p++) {
      Player thisPlayer = (Player)playerList.get(p);
      // pokaż rakietkę dla tego gracza:
      thisPlayer.showPaddle();
   }
   

// oblicz pozycję piłeczki:
   if (ballInMotion) {
      moveBall();
   }
   // narysuj piłeczkę:
   rect(ballPosH, ballPosV, ballSize, ballSize);
   
   // pokaż wynik:
   showScore();

   // jeśli gra skończy się, pokaż zwycięzcę:
   if (gameOver) {
      textSize(24);
      gameOver = true;
      text("Koniec gry", width/2, height/2 - 30);
      if (topScore > bottomScore) {
         text("Wygrała drużyna z góry!", width/2, height/2);
      }
      else {
         text("Wygrała drużyna z dołu!", width/2, height/2);
      }
   }
   // pauza po każdej grze:
   if (gameOver && (millis() > delayCounter + gameOverDelay)) {
      gameOver = false;
      newGame();
   }

   // pauza po każdym punkcie:
   if (!gameOver && !ballInMotion && (millis() >
      delayCounter + pointDelay)) {

         // upewnij się, że jest co najmniej dwóch graczy:
         if (playerList.size() >=2) {
            ballInMotion = true;
         }
         else {
            ballInMotion = false;
            textSize(24);
            text("Oczekujemy na dwóch graczy", width/2, height/2 - 30);
            // resetuj wynik:
            newGame();
         }
      }
   }

void moveBall() {
   //sprawdź, czy piłeczka dotyka którejkolwiek rakietki:
   for (int p = 0; p < playerList.size(); p++) {
      // pobierz gracza do sprawdzenia:
      Player thisPlayer = (Player)playerList.get(p);

      // oblicz poziome krawędzie rakietki:
      float paddleRight = thisPlayer.paddleH + paddleWidth/2;
      float paddleLeft = thisPlayer.paddleH - paddleWidth/2;
      // sprawdź, czy piłeczka jest w poziomym zakresie rakietki:
      if ((ballPosH >= paddleLeft) && (ballPosH <= paddleRight)) {

         // oblicz pionowe krawędzie rakietki:
         float paddleTop = thisPlayer.paddleV - paddleHeight/2;
         float paddleBottom = thisPlayer.paddleV + paddleHeight/2;

         // sprawdź, czy piłeczka jest w 
         // poziomym zakresie rakietki:
         if ((ballPosV >= paddleTop) && (ballPosV <= paddleBottom)) {
            // odwrócić kierunek pionowy piłeczki:
            ballDirectionV = -ballDirectionV;
         }
      }
   }

   // piłeczka wpada powyżej górnej krawędzi ekranu:
   if (ballPosV < 0) {
      bottomScore++;
      ballDirectionV = int(random(2) + 1) * -1;
      resetBall();
   }
   // jeśli piłka wpada powyżej dolnej krawędzi ekranu:
   if (ballPosV > height) {
      topScore++;
      ballDirectionV = int(random(2) + 1);
      resetBall();
   }

   // jeśli jakiś zespół przekracza 5 punktów, drugi zespół przegrywa:
   if ((topScore > 5) || (bottomScore > 5)) {
      delayCounter = millis();
      gameOver = true;
   }

   // zatrzymaj piłeczkę poruszającą się po lewej 
   // lub po prawej krawędzi ekranu:
   if ((ballPosH - ballSize/2 <= 0) || (ballPosH +ballSize/2 >=width)) {
      // odwrócić kierunek y piłki:
      ballDirectionH = -ballDirectionH;
   }
   // aktualizuj pozycję piłeczki:
   ballPosV = ballPosV + ballDirectionV;
   ballPosH = ballPosH + ballDirectionH;
}

void newGame() {
   gameOver = false;
   topScore = 0;
   bottomScore = 0;
}

public void showScore() {
   textSize(24);
   text(topScore, 20, 40);
   text(bottomScore, 20, height - 20);
}

void resetBall() {
   // umieścić piłkę ponownie na środku
   ballPosV = height/2;
   ballPosH = width/2;
   ballInMotion = false;
   delayCounter = millis();
}

public class Player {  
  // deklaracja zmiennych, które należą do obiektu:
  float paddleH, paddleV;
  Client  client;

  public Player (int hpos, int vpos, Client thisClient) {
    // inicjowanie lokalnych zmiennych instancji:
    paddleH = hpos;
    paddleV = vpos;
    client = thisClient;
  }

  public void movePaddle(float howMuch) {
    float newPosition = paddleH + howMuch;
    // ogranicz pozycję rakietki do szerokości okna:
    paddleH = constrain(newPosition, 0, width);
  }

  public void showPaddle() {
    rect(paddleH, paddleV, paddleWidth, paddleHeight); 
    // wyświetl adres tego gracza w pobliżu jego rakietki
    textSize(12); 
    text(client.ip(), paddleH, paddleV - paddleWidth/8 );
  }
}


