/* 
 Odczyt portu szeregowego
 Kontekst: Processing
 
 Odczytuje ciąg znaków, aż otrzyma znak wysuwu wiersza (ASCII 10).
 Następnie konwertuje ciąg znaków na liczbę.
 */
import processing.serial.*;

Serial myPort;              // port szeregowy
float sensorValue = 0;      // wartość z czujnika
float xPos = 0;             // położenie poziome wykresu 
float prevSensorValue = 0;  // poprzednia wartość czujnika 
float lastXPos = 0;         // poprzednie położenie poziome 

void setup() {
  size(400,300);
  // lista wszystkich dostępnych portów szeregowych 
  println(Serial.list());

  // Wiem, że pierwszy port szeregowy na liście 
  // na moim Mac-u jest zawsze moim 
  // Arduino, więc otwieram Serial.list()[0]. 
  // Otwórz ten port, którego używasz
  // (wyniki Serial.list() mogą pomóc; są one 
  // wymienione w kolejności począwszy od tego, 
  // który odpowiada [0]).
  myPort = new Serial(this, Serial.list()[0], 9600);

  // odczytuj bajty w buforze, aż otrzymasz 
  // znak nowego wiersza (ASCII 10):
  myPort.bufferUntil('\n');

  // Ustaw wstępny kolor tła i wygładzanie rysunków:
  background(#543174);
  smooth();
}

void draw () {
  // nic się tutaj nie dzieje 
}

// metoda serialEvent jest wywolywana automatycznie przez applet Processing
// za każdym razem kiedy bufor otrzyma wartość bajtu ustawioną w metodzie
// bufferUntil w setup():
void serialEvent (Serial myPort) {
  // pobierz łańcuch  znaków ASCII :
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    // wytnij wszystkie odstępy:
    inString = trim(inString);
    // konwertuj na liczby całkowite
    // i mapuj do wysokości ekranu:
    sensorValue = float(inString); 
    sensorValue = map(sensorValue, 0, 1023, 0, height);
    //println(sensorValue);
    drawGraph(prevSensorValue, sensorValue); 

    // zapamiętaj bieżącą wartość do następnego razu:
    prevSensorValue = sensorValue; 
  }
 } 

void drawGraph(float prevValue, float currentValue) {
  // odejmij wartości od wysokości okna, 
  // żeby większe wartości były rysowane wyżej
  // na ekranie:
  float yPos = height - currentValue;
  float lastYPos = height - prevValue;

  //narysuj linię w ładnym kolorze:
  stroke(#C7AFDE);
  line(lastXPos, lastYPos, xPos, yPos);

  // przy krawędzi ekranu wróć na początek:
  if (xPos >= width) {
    xPos = 0;
    lastXPos = 0;
    background(#543174);
  }
  else {
    // zwiększ położenie poziome o 1:
    xPos++;
    // zapamiętaj bieżącą pozycję wykresu 
    // do następnego razu:
    lastXPos = xPos;
  }
}

