/* 
 Monski Pong z wymianą potwierdzeń
 Kontekst: Processing
 

 Gra w monski pong!
 Oczekuje na porcie szeregowym wartości sensorów oddzielonych przecinkami:
 * w lewo (0 - 1023)
 * w prawo (0 - 1023)
 * reset(0 - 1)
 * serw(0 - 1)
 * powrót karetki, nowy wiersz

 Korzysta z metody wymiany potwierdzeń do zarządzania przepływem danych na porcie szeregowym. 

 */


import processing.serial.*; 	// import biblioteki szeregowej Processing 

Serial myPort; 				// port szeregowy
String resultString; 		// ciąg znaków z wynikami

float leftPaddle, rightPaddle; 	// zmienne dla czujnika ugięcia 
int resetButton, serveButton; 	// zmienne dla wartości przycisku
int leftPaddleX, rightPaddleX; 	// położenie poziome rakietek 
int paddleHeight = 50; 		// wymiary pionowe rakietek
int paddleWidth = 10; 		// wymiary poziome rakietek

float leftMinimum = 120; 	// minimalna wartość lewego czujnika ugięcia
float rightMinimum = 100; 	// minimalna wartość prawego czujnika ugięcia
float leftMaximum = 530; 	// maksymalna wartość lewego czujnika ugięcia
float rightMaximum = 500; 	// maksymalna wartość prawego czujnika ugięcia

int ballSize = 10;      // rozmiar piłeczki
int xDirection = 1;     // kierunek poziomy piłki
                        // w lewo –1, w prawo 1.
int yDirection = 1;     // kierunek pionowy piłki
                        // w górę –1, w dół 1.
int xPos, yPos;         // poziome i pionowe położenie piłki

boolean ballInMotion = false; // czy piłeczka powinna się poruszać

int leftScore = 0;      // wynik dla lewej rakietki
int rightScore = 0;     // wynik dla prawej rakietki

int fontSize = 36;      //  rozmiar czcionki punktacji 

void setup() {
  size(640, 480); 		// ustaw rozmiar okna apletu
  println(Serial.list()); 	// wypisz listę wszystkich dostępnych portów szeregowych

  // znajdź nazwę Twojego portu na liście.
  // Pierwszy port na liście na moim komputerze jest zazwyczaj
  // moim modułem Arduino, więc otwieram Serial.list()[0].
  // Zmień 0 na numer portu szeregowego,
  // do którego podłaczony jest Twój mikrokontroler:
  String portName = Serial.list()[1];
  // otwórz port szeregowy:
  myPort = new Serial(this, portName, 9600);
 
  // wczytuj bajty do bufora dopóki nie otrzymasz znaku wysuwu wiersza (ASCII 10):
  myPort.bufferUntil('\n');

  // inicjowanie wartości czujnika:
  leftPaddle = height/2;
  rightPaddle = height/2;
  resetButton = 0;
  serveButton = 0;

  // inicjowanie pozycji poziomej rakietki
  leftPaddleX = 50;
  rightPaddleX = width - 50;

  // ustaw brak konturu dla rysowanych kształtów:
  noStroke();

  // zainicjuj pozycję piłki na środku ekranu:
  xPos = width/2;
  yPos = height/2;

  // utwórz czcionkę z trzeciej czcionki dostępnej w systemie:
  PFont myFont = createFont(PFont.list()[2], fontSize);
  textFont(myFont);
}

void draw() {
  // ustaw kolory tła i wypełnienia dla okna apletu:
  background(#044f6f);
  fill(255);

  // narysuj lewą rakietkę:
  rect(leftPaddleX, leftPaddle, paddleWidth, paddleHeight);

  // narysuj prawą rakietkę:
  rect(rightPaddleX, rightPaddle, paddleWidth, paddleHeight);

  // oblicz pozycję piłki i narysuj ją:
  if (ballInMotion == true) {
    animateBall();
  }

  // jeżeli wciśnięty jest przycisk serw, wpraw piłkę w ruch:
  if (serveButton == 1) {
    ballInMotion = true;
  }

  // jeśli jest wciśnięty przycisk reset, resetuj wynik gry
  // i rozpocznij ruch piłeczki:
  if (resetButton == 1) {
    leftScore = 0;
    rightScore = 0;
    ballInMotion = true;
  }
  
  // wyświetl wyniki gry:
  text(leftScore, fontSize, fontSize);
  text(rightScore, width-fontSize, fontSize);
}

// metoda serialEvent jest uruchamiana automatycznie przez szkic Processing 
// zawsze kiedy bufor napotka bajt o wartości ustawionej w metodzie bufferUntil()
// w setup():

void serialEvent(Serial myPort) { 

  // odczytaj bufor portu szeregowego:
  String inputString = myPort.readStringUntil('\n');
     
  // wytnij znaki powrotu karetki oraz wysuwu wiersza z ciągu wejściowego:
  inputString = trim(inputString);
  // wyczyść zmienną resultString:
  resultString = "";

  // podziel ciąg wejściowy na przecinkach
  // i skonwertuj każdą sekcję do liczb całkowitych:
  int sensors[] = int(split(inputString, ','));
  // jeśli odebrałeś wszystkie odczyty czujnika, użyj ich:
  if (sensors.length == 4) {
    // przeskaluj odczyty czujnika ugięcia do zakresu ruchu rakietki:
    leftPaddle = map(sensors[0], leftMinimum, leftMaximum, 0, height);
    rightPaddle = map(sensors[1], rightMinimum, rightMaximum, 0, height);

    // przypisz wartości przełączników do zmiennych przycisków:
    resetButton = sensors[2];
    serveButton = sensors[3]; 

    // dodaj wartości do ciągu wynikowego:
    resultString += "lewy: "+ leftPaddle + "\tprawyt: " + rightPaddle;
    resultString += "\treset: "+ resetButton + "\tserw: " + serveButton;
  }
    // wyślij przez port szeregowy aby poprosić o dane:
      myPort.write('\r');
}

void animateBall() {
  // jeśli piłka porusza się w lewo:
  if (xDirection < 0) {
    // jeśli piłka jest po lewej stronie lewej rakietki:
    if  ((xPos <= leftPaddleX)) {
      // jeśli piłka jest między górną a dolną
      // krawędzią lewej rakietki:
      if((leftPaddle - (paddleHeight/2) <= yPos) && 
        (yPos <= leftPaddle + (paddleHeight /2))) {
        // odwróć kierunek poziomy:
        xDirection =-xDirection;
      }
    }
  }
  // jeśli piłka porusza się w prawo:
  else {
    // jeśli piłka jest po prawej stronie prawej rakietki:
    if  ((xPos >= ( rightPaddleX + ballSize/2))) {
      // jeśli piłka jest między górną a dolną
      // krawędzią prawej rakietki:
      if((rightPaddle - (paddleHeight/2) <=yPos) && 
        (yPos <= rightPaddle + (paddleHeight /2))) {
        // odwróć kierunek poziomy:
        xDirection =-xDirection;
      }
    }
  }
  // jeśli piłka wyszła poza ekran po lewej:
  if (xPos < 0) {
    rightScore++;
    resetBall();
  }
  // jeśli piłka wyszła poza ekran po prawej:
  if (xPos > width) {
    leftScore++;
    resetBall();
  }
  
  // powstrzymaj piłkę przed wyjściem poza górną lub dolną krawędź ekranu:
  if ((yPos - ballSize/2 <= 0) || (yPos +ballSize/2 >=height)) {
    // odwrócić kierunek y piłki :
    yDirection = -yDirection;
  }

  // aktualizacja pozycji piłki:
  xPos = xPos + xDirection;
  yPos = yPos + yDirection;

  // narysuj piłkę:
  rect(xPos, yPos, ballSize, ballSize);
}

void resetBall() {
  // umieść piłkę z powrotem na środku
  xPos = width/2;
  yPos = height/2;
}

