/*
  Odczyt oprogramowania wbudowanego SM130 
  Kontekst: Arduino
*/

#include <Wire.h>

void setup() {
  // inicjuj port szeregowy i I2C:
  Serial.begin(9600);
  Wire.begin();
  // daj czytnikowi czas na reset:
  delay(2000);

  Serial.println("pytanie o oprogramowanie wbudowane");
  // otwórz połączenie I2C,
  // adresem I2C czytnika jest 0x42:
  Wire.beginTransmission(0x42);
  Wire.write(0x01); // długość 
  Wire.write(0x81); // polecenie 
  Wire.write(0x82); // suma kontrolna 
  Wire.endTransmission();

  // czytnik wymaga 50 ms między odpowiedziami:	
  delay(50);
  Serial.print("uzyskana odpowiedź: ");
  // poczekaj na zwrócenie 10 bajtów z I2C:
  Wire.requestFrom(0x42,10);
  // nic nie rób, aż pojawią się nowe bajty:
  while(!Wire.available()) {
    delay(50);
  }
  // po nadejściu nowych bajtów na magistrali 
  // I2C, należy je odczytać:
  while(Wire.available()) {
    Serial.write(Wire.read());
  }
  // dodaj nowy wiersz:
  Serial.println();
}

void loop() {
}
