/*
  XBee na UDP
  Kontekst: Arduino
*/

#include <SPI.h>
#include <Ethernet.h>
#include <Udp.h>

// poniżej wprowadź adres MAC i adres IP kontrolera;
// adres IP będzie zależał od Twojej sieci lokalnej:
byte mac[] = {
  0x00, 0xAA, 0xBB, 0xCC, 0xDE, 0x02 };
IPAddress myIp(192,168,1,20);
IPAddress yourIp(192,168,1,21);

unsigned int myPort = 43770;     // port lokalny do nasłuchu
unsigned int yourPort = 43770;   // port zdalny do wysyłania

// instancja UDP do wysyłania i odbierania pakietów przez UDP 
UDP udp;

void setup() {
  // uruchom bibliotekę szeregową:
  Serial.begin(9600);
  // uruchom połączenie Ethernet:
  Ethernet.begin(mac, myIp);
  // uruchom UDP:
  udp.begin(myPort);
  // daj tarczy Ethernet sekundę na inicjowanie:
  delay(1000);
  // skonfiguruj pakiet do wysyłania:
  udp.beginPacket(yourIp, yourPort);
}

void loop() {
  if (Serial.available()) {
    int serialByte = Serial.read();
    // jeśli masz 0x7E,
    // wyślij pakiet i rozpocznij nowy:
    if (serialByte == 0x7E) {
      udp.endPacket();
      // skonfiguruj pakiet do wysyłania:
      udp.beginPacket(yourIp, yourPort);
    }
    // wyślij bajt:
    udp.write(serialByte);
  }
}
