/*
  Testowy program serwera
  Kontekst: Processing

  Tworzy serwer, który nasłuchuje klientów i drukuje, co mówią.
  Wysyła także do ostatniego klienta wszystko, co zostanie 
  wpisane na klawiaturze.
*/

// dołącz bibliotekę sieciową:
import processing.net.*;

int port = 8080;                     // port, na którym nasłuchuje serwer
Server myServer;                     // obiekt serwera
ArrayList clients = new ArrayList(); // lista klientów

void setup()
{
   myServer = new Server(this, port);
}

void draw()
{
   // pobierz następnego klienta, który wysyła wiadomości:
   Client speakingClient = myServer.available();

   if (speakingClient !=null) {
      String message = trim(speakingClient.readString());
      // wyświetl, kto wysłał wiadomość i co wysłał:
      println(speakingClient.ip() + "\t" + message);

      if (message.equals("koniec")) {
         myServer.disconnect(speakingClient);
         clients.remove(speakingClient);
      }
   }
}

// Komunikat ServerEvent message is generated when a new client
// connects to the server.
void serverEvent(Server myServer, Client thisClient) {
   println("Mamy nowego klienta: " + thisClient.ip());
   clients.add(thisClient);
}

void keyReleased() {
   myServer.write(key);
}

