/*
  Brama portu szeregowego na Ethernet
  Kontekst: Arduino
*/

#include <SPI.h>
#include <Ethernet.h>

// Poniżej wprowadź adres MAC i IP dla swojego kontrolera.
// Adres IP będzie zależeć od Twojej sieci lokalnej:
byte mac[] = { 0x00, 0xAA, 0xBB, 0xCC, 0xDE, 0x01 };
IPAddress ip(192,168,1,20);
IPAddress server(208,201,239,101);


// zainicjuj bibliotekę klienta Ethernet 
// z adresem IP i portem serwera, z którym 
// chcesz się połączyć (port 80 jest domyślny dla HTTP):
EthernetClient client;


void setup() {
   // Uruchom bibliotekę szeregową:
   Serial.begin(9600);
   
   // Uruchom połączenie Ethernet:
   if (!Ethernet.begin(mac)) {
      Serial.println("DHCP nie powiodło się, konfiguracja ręczna.");
      // skonfiguruj ręcznie swój adres IP:
      Ethernet.begin(mac, ip);
   }
   
   // daj tarczy Ethernet sekundę na zainicjalizowanie się:
   delay(1000);
   Serial.println("Gotowy do pracy.");
}

void loop() 
{

   if (client.connected()) {
      // jeśli jesteś połączony, przekazuj bajty 
      // z klienta do portu szeregowego:
      if (client.available()) {
         char netChar = client.read();
         Serial.write(netChar);
      }
      // przekazuj bajty z portu szeregowego do klienta:
      if (Serial.available()) {
         char serialChar = Serial.read();
         client.write(serialChar);
      }
   }
   else {
      // jeśli byłeś podłączony, zatrzymaj klienta:
      client.stop();
      
      // jeśli nie masz połączenia i otrzymasz szeregowo znak C,
      // to spróbuj się połączyć:
      if (Serial.available()) {
         char serialChar = Serial.read();
         if (serialChar == 'C') {
             connectToServer();
         }
      }
   }
}

void connectToServer() {
   // spróbuj się połączyć i odczekaj milisekundę:
   Serial.println("łączenie...");
   delay(1);
   if (client.connect(server, 80)) {
      // jeśli masz połączenie, powiadom o tym przez port szeregowy:
      Serial.println("połączony");

  }
   else {
      // jeśli nie można uzyskać połączenia z serwerem:
      Serial.println("połączenie nie powiodło się");
      client.stop();
   }
}


