/*
  Tester żądań HTTP z portu szeregowego na Ethernet
  Kontekst: Processing

*/
// dodaj bibliotekę szeregową
import processing.serial.*;

Serial myPort;        // obiekt portu szeregowego
int step = 0;         // na którym kroku procesu jesteś
char linefeed = 10;   // kod ASCII znaku wysuwu wiersza

void setup()
{
   // pobierz listę portów szeregowych:
   println(Serial.list());
   // otwórz port szeregowy odpowiedni dla Twojego komputera:
   myPort = new Serial(this, Serial.list()[0], 9600);
   // konfiguruj obiekt szeregowy, żeby buforował 
   // tekst do czasu otrzymania znaku wysuwu wiersza:
   myPort.bufferUntil(linefeed);
}

void draw()
{
   // brak akcji w pętli draw 
}

void serialEvent(Serial myPort) {
   // wyświetl dowolny ciąg, który 
   // przychodzi szeregowo w panelu monitora: 
   print(myPort.readString());
}

void keyReleased() {
   // jeśli zostanie wciśnięty dowolny klawisz, 
   // przejdź do następnego kroku:
   switch (step) {
   case 0:
      // otwórz połączenie z wybranym serwerem:
      myPort.write("C");
      // dodaj jeden do zmiennej step, żeby 
      // następne naciśnięcie klawisza spowodowało 
      // następny krok:
      step++;
      break;
   case 1:
      // wyślij żądanie HTTP GET
      myPort.write("GET /~myaccount/index.html HTTP/1.1\n");
      myPort.write("HOST:myserver.com\n\n");
      step++;
      break;
   }
}

