/**
  Przechwytywanie i przekazywanie obrazu 
  Kontekst: Processing
 
 created 2 Oct 2010
 modified: 14 Nov 2010
 by Tom Igoe
*/
import processing.video.*;
import processing.net.*;

Capture myCam;
String fileName = "catcam.jpg";

String baseUrl = "/mtt2/save2web.php";
String boundary = "----H4rkNrF";
Client thisClient;

void setup() {
  size(640, 480);

  // Aby wybrać inne urządzenie (np. jeśli domyślne urządzenie powoduje błąd)
  // wypisz wszystkie dostępne urządzenia przechwytujące obraz na konsoli
  // aby znaleźć swoją kamerę.
  String[] devices = Capture.list();
  println(devices);

  // zmień devices[0] na odpowiedni indeks swojej kamery.
  myCam = new Capture(this, width, height, devices[0]);
}


void draw() {
  if (myCam.available() == true) {
    // narysuj obraz z kamery na ekranie
    myCam.read();
    set(0, 0, myCam);
    // pobierz czas jako łańcuch znaków:
    String timeStamp = nf(hour(), 2) + ":" + nf(minute(), 2) 
      + ":" + nf(second(), 2) + " " + nf(day(), 2) + "-" 
        + nf(month(), 2) + "-" +  nf(year(), 4);

    // narysuj cień pod tekstem z czasem:
    fill(15);
    text(timeStamp, 11, height - 19);
    // narysuj glówny tekst z czasem:
    fill(255);
    text(timeStamp, 10, height - 20);
  }
} 
void clientEvent (Client thisClient) {
  // If there's incoming data from the client
  // then grab it and print it
  while (thisClient.available() > 0) { 
    String data = thisClient.readString(); 
    println(data);
  }
}

void keyReleased() {
  PImage img = get();
  img.save(fileName);
  postPicture();
 // loadStrings("http://www.www.example.com/mailer.php");
}

void postPicture() {
  // załaduj zapisany obraz do tablicy bajtów:
  byte[] thisFile =loadBytes(fileName);

  // otwórz nowe połączenie z serwerem:
  thisClient = new Client(this, "www.tigoe.net", 80);
  // skonstruuj żądanie HTTP POST:
  thisClient.write("POST " + baseUrl + " HTTP/1.1\n"); 
  thisClient.write("Host: tigoe.net\n");
  // powiedz serwerowi, że wysyłasz żądanie POST w wielu częściach,
  // i wyślij unikatowy ciąg, który będzie rozdzielał części:
  thisClient.write("Content-Type: multipart/form-data; boundary=");
  thisClient.write(boundary + "\n");

  // sformułuj początek żądania:
  String requestHead ="\n--" + boundary + "\n";
  requestHead +="Content-Disposition: form-data; name=\"file\"; ";
  requestHead += "filename=\"" + fileName + "\"\n";
  requestHead +="Content-Type: image/jpeg\n\n";

  // sformułuj koniec żądania:
  String tail ="\n\n--" + boundary + "--\n\n";

  // oblicz i wyślij długość całego żądania,
  // wliczając w to nagłówek żądania, plik i ogon:
  int contentLength = requestHead.length() + thisFile.length + tail.length();
  thisClient.write("Content-Length: " + contentLength + "\n\n");  

  // wyślij nagłówek żądania, plik i ogon:
  thisClient.write(requestHead);
  thisClient.write(thisFile);
  thisClient.write(tail);

  // zamknij klienta:
  thisClient.stop();
}

