/*
  Test Processing dla Androida
  Kontekst: Processing
*/
float ballX, ballY;   // pozycja kulki
// plik do zapisywania danych przy wstrzymaniu i wznawianiu:
String datafile = "sketchFile.dat";

void setup() {
  // utwórz czcionkę dla ekranu:
  String[]fontList = PFont.list();
  PFont androidFont = createFont(fontList[0], 24, true);
  textFont(androidFont, 24);
}

void draw() {

  // motyw kolorów: Sandy stone beach ocean diver
  // autor: ps, http://kuler.adobe.com:
  background(#002F2F);
  fill(#EFECCA);
  // pokaż x i y myszy i nacisk palca:
  text("mouseX:" + mouseX, 10, 50);
  text("mouseY:" + mouseY, 10, 80);
  text("motionPressure:" + motionPressure, 10, 170);
  // przesuń kulkę, jeśli osoba naciśnie:
  if (mousePressed) {
    ballX = mouseX;
    ballY = mouseY;
  }
  // narysuj ładną niebieską kulkę tam, gdzie dotykasz:
  fill(#046380);
  ellipse(ballX, ballY, 50, 50);
}

void pause() {
  // wprowadź ciąg pozycji kulki:
  String ballPos = ballX+ "\n" + ballY;
  // umieść ciąg w tablicy i zapisz w pliku:
  String[] data = {
    ballPos
  };
  saveStrings(datafile, data);
}

void resume() {
  // załaduj plik danych:
  String[] data = loadStrings(datafile);
  // jeśli plik istnieje:
  if (data != null) {
    // i istnieją dwa ciągi, uzyskaj X i Y:
    if (data.length > 1) {
      ballX = float(data[0]);
      ballY = float(data[1]);
    }
  }
}

