/*
  Odczyt siły sygnału XBee 
  Kontekst: Processing

  Odczytuje pakiet z radia XBee i parsuje go. 
  Pakiet powinien mieć 22 bajty. Powinien składać się 
  z następujących elementów:
  bajt 1:        0x7E, wartość bajtu startu,
  bajty 2 - 3:   rozmiar pakietu,  wartość 2 bajtów (nie używane tutaj),
  bajt 4:        wartości identyfikatora interfejsu API, kod, który mówi,   
                 jaka jest odpowiedź (nie używane tutaj),
  bajty 5 - 6:   adres nadawcy, 
  bajt 7:        RSSI, wskaźnik siły odebranego sygnału 
                 (nie używane tutaj),
  bajt 8:        opcje rozgłaszania (nie używane tutaj),
  bajt 9:        liczba próbek, które należy wykonać, 
  bajty 10 -– 11: wskaźnik aktywnego kanału (nie używane tutaj),
  bajty 12 -– 21: 5 wartości 10-bitowa wartość, każdej próbki ADC 
                  od nadawcy. 
*/

import processing.serial.*;
Serial XBee ;               // wejściowy port szeregowy radia XBee 
int[] packet = new int[22]; // pakiet XBee składający się z 5 próbek 
                            // pakiet XBee jest długi na 22 bajty
int byteCounter;            // gdzie jesteś w pakiecie 
int rssi = 0;               // siła odebranego sygnału 
int address = 0;            // adres wysyłającego XBee 
int lastReading = 0;        // wartość poprzedniego bajtu przychodzącego

void setup () {
  size(320, 480);            // rozmiar okna 

  // uzyskaj listę portów szeregowych:
  println(Serial.list());
  // otwórz port szeregowy dołączony do radia XBee:
  XBee = new Serial(this, Serial.list()[0], 9600);
}

void draw() {
  // jeśli masz nowe dane i są poprawne (> 0), to narysuj na wykresie:
  if ((rssi > 0 ) && (rssi != lastReading)) {
    // ustaw kolor tła:
    background(0);
    // ustaw wysokość i szerokość paska:
    int rectHeight = rssi;
    int rectWidth = 50;
    // narysuj prostokąt:
    stroke(23, 127, 255);
    fill (23, 127, 255);
    rect(width/2 - rectWidth, height-rectHeight, rectWidth, height);
    // wyświetl wartość:
    text("Test siły sygnału radia XBee ", 10, 20);
    text("Otrzymane z XBee z adresem: " + hex(address), 10, 40);

    text ("Siła odebranego sygnału: -" + rssi + " dBm", 10, 60);
    // zapisz bieżący bajt dla następnego odczytu:
    lastReading = rssi;
  }
}

void serialEvent(Serial XBee ) {
  // odczytaj bajt z portu:
  int thisByte = XBee.read();
  // jeśli bajt = 0x7E, czyli wartość bajtu rozpoczęcia, 
  // masz nowy pakiet:
  if (thisByte == 0x7E) { // start byte
    // parsuj poprzedni pakiet, jeśli brak danych:
    if (packet[2] > 0) {
      rssi = parseData(packet);
    }
    // wyzeruj licznik bajtów:
    byteCounter = 0;
  }
  // ustaw bieżący bajt w pakiecie jako bieżącą pozycję:
  packet[byteCounter] = thisByte;
  // zwiększ o 1 licznik bajtów:
  byteCounter++;
}

/*
  Kiedy masz pakiet, należy wyodrębnić przydatne dane.
  Metoda ta pobiera adres nadawcy i RSSI.
*/
int parseData(int[] thisPacket) {
  int result = -1;           // jeśli nie otrzymasz żadnego wyniku, 
                             // zostanie to wskazane przez wartość -1.

  // Upewnij się, że masz wystarczającą część pakietu 
  // do odczytania danych:
  if (thisPacket.length > 6) {
    // odczytaj adres. Jest to wartość dwubajtowa, 
    // więc musisz dodać dwa bajty:
    address = thisPacket[5] + thisPacket[4] * 256;
    // pobierz RSSI:
    result = thisPacket[6];
  }
  return result;
}


