/*
  Odczyt reakcji skórno-galwanicznej
  Kontekst: Arduino
*/

const int voltagePin = 11;  // użyj pinu 11 jako napięcia 
const int groundPin = A1;   // użyj pinu A1 jako masy

void setup() {
  // inicjuj port szeregowy:
  Serial.begin(115200);
  // ustaw powerPin i groundPin jako cyfrowe wyjścia:
  pinMode(voltagePin, OUTPUT);
  pinMode(groundPin, OUTPUT);
  // ustaw je, odpowiednio: na wysoki i niski:
  digitalWrite(voltagePin, HIGH);
  digitalWrite(groundPin, LOW);
}

void loop() {
  // jeśli port szeregowy jest dostępny, wyślij średnią
  if (Serial.available() > 0) {
    int inByte = Serial.read();
    int sensorReading = analogRead(A0);
    float voltage = map(sensorReading, 0, 1023, 0,3.7);
    Serial.println(voltage);
  }
}

