/*
  Odczyt wersji oprogramowania wbudowanego czytnika SonMicro 
  Kontekst: Processing
*/

import processing.serial.*;
Serial myPort;    // port szeregowy
String binaryString = "";
String asciiString = "";

void setup() {
  size(500, 200);   // rozmiar okna
  // lista wszystkich dostępnych portów szeregowych 
  println(Serial.list());
  // otwórz port, którego używasz
  myPort = new Serial(this, Serial.list()[2], 19200);
}

void draw() {
  // schemat kolorów Dystopian waterscape,
  // autor: arem114, http://kuler.adobe.com/
  background(#7B9B9D);
  fill(#59462E);
  // napisz odpowiedź, szesnastkowo i w ASCII:
  text(binaryString, 10, height/3);
  text(asciiString, 10, 2*height/3);
}

void keyReleased() {
  int command = 0x81;   // polecenie odczytu oprogramowania 
                        // wbudowanego jest domyślne 
  int dataLength = 1;   // długość danych dla obu poleceń 
                        // jest równa 1
  if (key == 's') {     // polecenie "wyboru znacznika"
    command = 0x83;
  }
  // wyślij polecenie:
  myPort.write(0xFF);
  myPort.write(0x00);
  myPort.write(dataLength);
  myPort.write(command);
  myPort.write(command + dataLength);
  // resetuj ciągi odpowiedzi:
  binaryString = "";
  asciiString = "";
}

void serialEvent(Serial myPort) {
  // weź następny przychodzący bajt:
  char thisChar = (char)myPort.read();
  // dodaj bajt do ciągu odpowiedzi:
  binaryString += hex(thisChar, 2) + " ";
  asciiString += thisChar;
}

