/*
  Czytnik RFID ID Innovations 
  Kontekst: Processing

  Odczytuje dane szeregowo z czytnika RFID ID Innovations ID-12 .
*/

// import biblioteki szeregowej:
import processing.serial.*;

Serial myPort;      // port szeregowy, którego używasz
String tagID = "";  // ciąg dla ID znacznika 

void setup() {
  size(150,150);
  // lista wszystkich portów szerergowychszeregowych:
  println(Serial.list());

  // zmień poniższy numer, by odpowiadał Twojemu portowi:
  String portnum = Serial.list()[2];
  // inicjuj port szeregowy:
  myPort = new Serial(this, portnum, 9600);
  // przychodzący ciąg zakończy się 0x03:
  myPort.bufferUntil(0x03);
}

void draw() {
  // wyczyścić ekran i wybierz przyjemne kolory 
  // zainspirowane morskim krajobrazem:
  background(#022E61);
  fill(#D9EADD);
  // wyświetl ciąg na ekranie:
  text(tagID, width/4, height/2);
}

/* 
  Ta metoda odczytuje bajty z portu szeregowego
  i umieszcza je w łańcuchu znacznika
*/

void serialEvent(Serial myPort) {
  // uzyskaj szeregowy bufor wejściowy jako ciąg znaków:
  String inputString = myPort.readString();

  // odfiltruj identyfikator znacznika z ciągu:

  // pierwszy znak wejścia:
  char firstChar = inputString.charAt(0);
  // ostatni znak wejścia:
  char lastChar = inputString.charAt(inputString.length() -1);

  // jeśli pierwszym znakiem jest STX (0x02) 
  // i ostatnim znakiem jest ETX (0x03), 
  // weź następne 10 bajtów ciągu tagID:

  if ((firstChar == 0x02) && (lastChar == 0x03)) {
    tagID = inputString.substring(1, 11);
  }
}

