/*
  Pochylenie akcelerometru
  Kontekst: Processing 

  Szeregowo pobiera wartości z akcelerometru dołączonego 
  do mikrokontrolera i używa ich do ustawienia pozycji 
  dysku na ekranie.
*/

import processing.serial.*;   // import biblioteki szeregowej

float pitch, roll;            // obrót względem osi X i Y
float position;               // pozycja do przesunięcia

Serial myPort;                // port szeregowy

void setup() {
  // rysowanie okna:
  size(400, 400, P3D);
  // oblicz pozycję przesunięcia dla dysku:
  position = width/2;

  // lista wszystkich dostępnych portów szeregowych:
  println(Serial.list());

  // otwórz ten port, którego używasz:
  myPort = new Serial(this, Serial.list()[2], 9600);
  // wygeneruj zdarzenie szeregowe, 
  // tylko jeśli otrzymasz nowy wiersz:
  myPort.bufferUntil('\n');
  // włącz wygładzanie dla 3D:
  smooth(4);
}

void draw () {
  // kolory zainspirowane amazońskim lasem deszczowym:
  background(#20542E);
  fill(#79BF3D);
  // rysuj dysk:
  tilt();
}


void tilt() {
  // przesuń, aby wyśrodkować na ekranie:
  translate(position, position, position);

  // X to przód-tył:
  rotateX(radians(roll + 90));
  // Y to lewo-prawo:
  rotateY(radians(pitch) );

  // ustaw kolor wypełnienia dysku:
  fill(#79BF3D);
  // narysuj dysk:
  ellipse(0, 0, width/4, width/4);
  // ustaw kolor wypełnienia tekstu:
  fill(#20542E);
  // narysuj jakiś tekst, aby móc odróżnić przód od tyłu:
  text(pitch + "," + roll, -40, 10, 1);
}

// metoda serialEvent jest wywoływana automatycznie przez applet Processing
// za każdym razem kiedy w buforze pojawi się wartość bajtu ustawiona 
// w metodzie bufferUntil w setup():

void serialEvent(Serial myPort) {
  // odczytaj bufor szeregowy:
  String myString = myPort.readStringUntil('\n');

  // jeśli są jakiekolwiek bajty inne niż wysuw wiersza:
  if (myString != null) {
    myString = trim(myString);
    // podziel łańcuch na miejscach przecinków:
    String items[] = split(myString, ',');
    if (items.length > 1) {
      pitch = float(items[0]);
      roll = float(items[1]);
    }
  }
}

