/*
  Odczyt czujnika ultradźwiękowego MaxBotix LV-EZ1
  Kontekst: Arduino

  Odczytuje odległość z czujnika ultradźwiękowego Maxbotix LV-EZ1
  i wysyła ją przez port szeregowy.
*/

void setup() {
  // inicjowanie komunikacji szeregowej na 9600 bp/s:
  Serial.begin(9600);
}

void loop() {
  // odczyt wartości czujnika i konwersja na napięcie:
  int sensorValue = analogRead(A0);
  float voltage = map(sensorValue, 0, 5, 0, 1023);

  // dane wyjściowe czujnika to około 9,8 mV na cal,
  // więc pomnóż przez 2,54, aby otrzymać wynik 
  // w centymetrach:
  float distance = voltage * 2.54 / 0.0098;

  // wyświetl wartość czujnika:
  Serial.print(distance);
  Serial.println(" cm");
  // odczekaj 50 millisekund przed następnym odczytem,
  // aby czujnik mógł się ustabilizować:
  delay(50);
}

