/*
  Odpowiedź na zapytanie UDP
  Kontekst: Arduino

*/

#include <SPI.h>
#include <Ethernet.h>
#include <Udp.h>

//wprowadź adres MAC i adres IP kontrolera poniżej.
//Adres IP będzie zależał od sieci lokalnej:
byte mac[] = {
  0x00, 0xAA, 0xBB, 0xCC, 0xDE, 0x01 };
IPAddress myIp(192,168,1,20);
unsigned int myPort = 43770;      // lokalny port nasłuchu

// instancja UDP do wysyłania i odbierania pakietów UDP 
UDP query;

void setup() {
  // uruchom bibliotekę szeregową:
  Serial.begin(9600);

  // uruchom połączenie Ethernet:
  // if (!Ethernet.begin(mac)) {
  Ethernet.begin(mac, myIp);
  // }
  // wyświetl swój adres:
  for (int thisByte = 0; thisByte < 4; thisByte++) {
    Serial.print(Ethernet.localIP()[thisByte], DEC);
    Serial.print(".");
  }
  Serial.println();

  query.begin(myPort);
  // daj tarczy Ethernet sekundę na zainicjalizowanie się:
  delay(1000);
}
i portami szeregowymi.
void loop()
{
  listen(query, myPort);
}

void listen(UDP thisUDP, unsigned int thisPort) {
  // sprawdź, czy jest pakiet przychodzący, 
  // i sparsuj nagłówek:
  int messageSize = thisUDP.parsePacket();
  // jeśli jest ładunek, to parsuj wszystko:
  if (messageSize > 0) {
    Serial.print("otrzymano wiadomość od: ");
    // uzyskaj zdalny adres i port:
    IPAddress yourIp = thisUDP.remoteIP();
    unsigned int yourPort = thisUDP.remotePort();
    for (int thisByte = 0; thisByte < 4; thisByte++) {
      Serial.print(yourIp[thisByte], DEC);
      Serial.print(".");
    }
    Serial.println(" na porcie: " + String(thisPort));
    // wyślij ładunek na port szeregowy:
    while (thisUDP.available() > 0) {
      // odczytaj pakiet do packetBufffer
      int udpByte = thisUDP.read();
      Serial.write(udpByte);
    }
    sendPacket(thisUDP, Ethernet.localIP(), yourIp, yourPort);
  }
}


void sendPacket(UDP thisUDP, IPAddress thisAddress,
           IPAddress destAddress, unsigned int destPort) {
  // skonfiguruj pakiet do wysyłania:
  thisUDP.beginPacket(destAddress, destPort);
  for (int thisByte = 0; thisByte < 4; thisByte++) {
    // wyślij bajt:
    thisUDP.print(thisAddress[thisByte], DEC);
    thisUDP.print(".");
  }
  thisUDP.println("Cześć tam!");
  thisUDP.endPacket();
}
