/*
 XBee Analog Duplex sender
 Kontekst: Arduino
 
 This sketch configures an XBee radio via the serial port, 
 sends the value of an analog sensor out, and listens for input 
 from the radio, using it to set the value of a PWM output. 
 Thanks to Robert Faludi for the critique and improvements.
 */

const int sensorPin = A0;     // czujnik wejściowy
const int analogLed = 3;      // dioda LED, która zmienia jasność 
                              // zgodnie z otrzymanymi wartościami 
const int threshold = 10;     // próg dla zmiany czujnika 

int lastSensorReading = 0;    // poprzedni stan czujnika 

String inputString = "";

void setup() {
  // konfiguracja komunikacji szeregowej:
  Serial.begin(9600);

  // konfiguracja pinu wyjściowego:
  pinMode (analogLed, OUTPUT);

  // ustaw adres docelowy XBee:
  setDestination();
  // zamigaj diodą TX, wskazując, że główny program 
  // zaraz się zacznie:
   blink(analogLed, 3);
}


void loop() {
  // nasłuchuj przychodzących danych szeregowych:
  if (Serial.available() > 0) {
    handleSerial();
  }
  // nasłuchuj potencjometru:
  int sensorValue = readSensor();

  // jeśli jest coś do wysyłania, wyślij to:
  if (sensorValue > 0) {
    Serial.println(sensorValue, DEC);
  }
}

void setDestination() {
  // przełącz radio w tryb poleceń:
  Serial.print("+++");
  // poczekaj, aż radio odpowie "OK\r"
  char thisByte = 0;
  while (thisByte != '\r') {
    if (Serial.available() > 0) {
      thisByte = Serial.read();
    }
  }

  // ustaw adres docelowy, przy użyciu 16-bitowego adresowania.
  // Jeśli używasz dwóch modułów, adresem docelowym jednego radia 
  // powinien być adres drugiego radia, i odwrotnie:
  Serial.print("ATDH0, DL5678\r");
  // ustaw mój adres przy użyciu 16-bitowego adresowania:
   Serial.print("ATMY1234\r");
  // ustaw PAN ID. Jeśli pracujesz w miejscu, gdzie wiele osób 
  // używa XBee, należy ustawić własne PAN ID,
  // inne niż w pozostałych projektach:.
  Serial.print("ATID1111\r");
  // przełącz radio w tryb danych:
  Serial.print("ATCN\r");
}

void blink(int thisPin, int howManyTimes) {
  // zamigaj diodą LED:
  for (int blinks=0; blinks< howManyTimes; blinks++) {
    digitalWrite(thisPin, HIGH);
    delay(200);
    digitalWrite(thisPin, LOW);
    delay(200);
  }
}

void handleSerial() {
  char inByte = Serial.read();

  // zapisz tylko znaki numeryczne ASCII (ASCII 0 - 9):
  if (isDigit(inByte)){
    inputString = inputString + inByte;
  }

  // jeśli otrzymasz znak ASCII dla nowej linii:
  if (inByte == '\n') {
    // skonwertuj ciąg znaków na liczbę :
    int brightness = inputString.toInt();
    // ustaw analogowe wyjście LED:
    analogWrite(analogLed, brightness);
    // wyczyść ciąg wejściowy dla następnej wartości:
    inputString = "";
    Serial.print(brightness);
   }
}

int readSensor() {
  int result = analogRead(sensorPin);
  // czekaj na zmianę w stosunku do ostatniego odczytu, 
  // która jest większa niż próg:
  if (abs(result - lastSensorReading) > threshold) {
    result = result/4;
    lastSensorReading = result;
  } else {
    // jeśli zmiana nie jest znacząca, zwróć 0:
    result = 0;
  }
  return result;
}
