/*
  Sterowanie aparatem fotograficznym przez IR
  Kontekst: Arduino

  Ten szkic steruje aparatem cyfrowym za pomocą podczerwonej diody LED.
*/

//dołącz bibliotekę do sterowania kamerą:
#include <multiCameraIrControl.h>

const int pushButtonPin = 4;
// ustaw pin 3 do sterowania diodą IR LED.
// Zzmień to ustawienie w zależności 
// od marki aparatu fotograficznego:
Nikon camera(3);

// zmienne, które reprezentują:
int buttonState = 0;        // bieżący stan przycisku
int lastButtonState = 0;    // poprzedni stan przycisku

void setup(){
  // zainicjuj przycisk jako wejście:
  pinMode(pushButtonPin, INPUT);
}

void loop(){
  // odczytaj pin wejściowy przycisku:
  buttonState = digitalRead(pushButtonPin);

  // porównaj buttonState ze stanem poprzednim.
  // jeśli został zmieniony, i jest teraz jest wysoki, to 
  // właśnie naciśnięto przycisk:
  if (buttonState != lastButtonState && buttonState == HIGH) {
    //wyślij sygnał otwarcia migawki:
    camera.shutterNow();
  }
  // zapisz bieżący stan jako ostatni stan,
  // dla następnej iteracji pętli 
  lastButtonState = buttonState;
}

