/* 
 Odczyt portu szeregowego
 Kontekst: Processing
 
 Odczytuje ciąg znaków, aż otrzyma znak wysuw wiersza (ASCII 10).
 Następnie konwertuje ciąg znaków na liczbę.
 */
import processing.serial.*;

Serial myPort;              // port szeregowy
float sensorValue = 0;      // wartość z czujnika
float xPos = 0;             // położenie poziome wykresu 
float prevSensorValue = 0;  // poprzednia wartość czujnika 
float lastXPos = 0;         // poprzednie położenie poziome
int threshold = 250;        // powyżej tej liczby kot jest na macie.

int lastTimeSent = 0;       // czas ostatniego wysłania poczty 
int timeThreshold = 1;      // minimum minut pomiędzy wiadomościami poczty
String mailUrl = "http://www.example.com/cat-script.php";

void setup() {
  size(400,300);
  // lista wszystkich dostępnych portów szeregowych 
  println(Serial.list());

  // Wiem, że pierwszy port szeregowy na liście na moim Mac-u jest zawsze moim 
  // Arduino, więc otwieram Serial.list()[0]. Otwórz ten port, którego używasz
  // (wyniki Serial.list() mogą pomóc; są one wymienione w kolejności
  // począwszy od tego, który odpowiada [0]).
  myPort = new Serial(this, Serial.list()[0], 9600);

  // odczytuj bajty w buforze, aż otrzymasz znak nowego wiersza  (ASCII 10):
  myPort.bufferUntil('\n');

  // Ustaw wstępny kolor tła i wygładzanie rysunków:
  background(#543174);
  smooth();
}

void draw () {
}

// metoda serialEvent jest wywolywana automatycznie przez applet Processing
// za każdym razem kiedy bufor otrzyma wartość bajtu ustawioną w metodzie
// bufferUntil w setup():
void serialEvent (Serial myPort) {
  // pobierz łańcuch  znaków ASCII :
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    // wytnij wszystkie odstępy :
    inString = trim(inString);
    // konwertuj do liczb całkowitych i mapuj do wysokości ekranu:
    sensorValue = float(inString); 
    sensorValue = map(sensorValue, 0, 1023, 0, height);
    //println(sensorValue);
    drawGraph(prevSensorValue, sensorValue); 

    if (sensorValue > threshold ) {
      // jeśli ostatni odczyt był mniejszy od progu,
      // to kot właśnie jest na macie.
      if (prevSensorValue <= threshold) {
        println("kot jest na macie");
        sendMail();
      }
    } 
    else {
      // jeśli wartość czujnika jest mniejsza niż próg ,
      // a poprzednia wartość była większa, to kot 
      // właśnie opuścił matę
      if (prevSensorValue > threshold) {
        println("kota nie ma na macie");
      }
    }
    // zapamiętaj bieżącą wartość do następnego razu:
    prevSensorValue = sensorValue; 
  }
} 

void drawGraph(float prevValue, float currentValue) {
  // odejmij wartości od wysokości okna 
  // żeby większe wartości były rysowane wyżej
  // na ekranie:
  float yPos = height - currentValue;
  float lastYPos = height - prevValue;

  //narysuj linię w ładnym kolorze:
  stroke(#C7AFDE);
  line(lastXPos, lastYPos, xPos, yPos);

  // przy krawędzi ekranu wróć na początek:
  if (xPos >= width) {
    xPos = 0;
    lastXPos = 0;
    background(#543174);
  }
  else {
    // zwiększ położenie poziome o 1:
    xPos++;
    // zapamiętaj bieżącą pozycję wykresu 
    // do następnego razu:
    lastXPos = xPos;
  }
}

void sendMail() {
  // ile czasu upłynęło od ostatniej wiadomości pocztowej:
  int timeDifference = 0;   
  // pobierz bieżący czas:
  int thisMinute = minute();

  // jeśli bieżąca minuta jest mniejsza niż poprzednia
  // to zmienila się godzina:
  if (thisMinute < lastTimeSent) {
    timeDifference = (60 - lastTimeSent) + thisMinute;
  } 
  // jeśli bieżąca minuta jest większa od ostatniej, to 
  // to godzina jest ta sama:
  else {
    timeDifference = thisMinute -  lastTimeSent;
  }

  if ( timeDifference > timeThreshold) {
    String[] mailScript = loadStrings(mailUrl);
    println("wyniki ze skryptu pocztowego:");
    println(mailScript);

  // zapisz bieżący czas do użycia następnym razem:
  lastTimeSent = thisMinute;
  }
}

