/*
  Akcelerometr I2C
  Kontekst: Arduino

  Odczytuje kompas ST Microelectronics LSM303DLH i wyświetla 
  wyjścia osi X i Y akceletrometru.

  utworzony 30 kwietnia 2011
  przez Toma Igoe

*/

// zaimportuj niezbędne biblioteki:
#include <LSM303DLH.h>
#include <Wire.h>

// zainicjuj kompas:
LSM303DLH compass;

void setup() {
  // zainicjuj biblioteki Serial i Wire oraz włącz kompas:
  Serial.begin(9600);
  Wire.begin();
  compass.enable();

  // skalibruj przez pierwsze pięć sekund po uruchomieniu:
  while (millis() < 5000) {
    compass.calibrate();
  }
}

void loop() {
  // odczytaj kompas i wyświetl odczyty X i Y akcelerometru:
  compass.read();
  Serial.print(compass.pitch());  // kąt w osi X
  Serial.print(",");
  Serial.println(compass.roll()); // kąt w osi Y 
  delay(100);
}

