/*
  Odczyt wiadomości XBee
  Kontekst: Arduino
 */

const int packetLength = 22;  // Wiadomości danych XBee będą mieć 
                              // długość 22 bajtów
int dataPacket[packetLength]; // tablica do przechowywania danych XBee
int byteCounter = 0;          // licznik dla bajtów odebranych z XBee

void setup() {
  // uruchom komunikację szeregową:
  Serial.begin(9600);
}

void loop() {
  // nasłuchuje przychodzących danych szeregowych:
  if (Serial.available() > 0) {
    listenToSerial();
  }
}

// ta metoda odbiera dane szeregowe i zapisuje je
// w tablicy
void listenToSerial() {
  // przeczytaj przychodzący bajt:
  int inByte = Serial.read();
  // początekiem nowego pakietu jest 0x7E:
  if (inByte == 0x7E ) {
    // sparsuj ostatni pakiet i pobierz odczyt:
    int thisReading = parseData();
    // wyświetl odczyt:
    Serial.println(thisReading);
    // opróżnij tablicę danych:
    for (int thisByte = 0; thisByte < packetLength; thisByte++) {
      dataPacket[thisByte] = 0;
    }
    // zresetuj licznik przychodzących bajtów:
    byteCounter = 0; 
  } 
  // jeśli licznik bajtow jest mniejszy niż długość pakietu,
  // doda ten bajt do tablicy danych:
  if (byteCounter < packetLength) {
    dataPacket[byteCounter] = inByte;
    // zwiększ licznik bajtów:
    byteCounter++;
  }  
}

// Ta metoda parsuje format danych XBee
// i zwraca uśrednioną wartość czujnika dla pakietu
int parseData() {
  int adcStart = 11;                     // odczyt ADC zaczyna się na bajcie 12
  int numSamples = dataPacket[8];        // liczba próbek w pakiecie
  int total = 0;                         // suma wszystkich odczytów ADC

  // odczyta adres. Jest to wartość dwu-bajtowa, więc dodaj 
  // dwa bajty następująco:
  int address = dataPacket[5] + dataPacket[4] * 256;

  // odczytaj <numSamples> 10-bitowych wartości analogowych, po dwie na raz
  // ponieważ każdy odczyt ma długość dwóch bajtów:
  for (int thisByte = 0; thisByte < numSamples * 2;  thisByte=thisByte+2) {
    // wartość 10-bitowa = bajt wysoki * 256 + bajt niski:
    int thisSample = (dataPacket[thisByte + adcStart] * 256) + 
      dataPacket[(thisByte + 1) + adcStart];
    // dodaj wynik do sumy aby później ją uśrednić:
    total = total + thisSample;
  }
  // uśrednij wynik:
  int average = total / numSamples;
  return average;
}

