/**
 Przechwytywanie i przekazywanie obrazu
 Kontekst: Processing
 
 utworzony 2 Oct 2010
 zmodyfikowany: 9 Oct 2010
 przez Toma Igoe
 */
import processing.video.*;
import processing.net.*;


import processing.serial.*;

Serial myPort;        // port szeregowy
float xPos = 0;       // położenie poziome wykresu 
float yPos = 0;       // położenie pionowe wykresu 
float lastXPos = 0;   // poprzednie położenie poziome
float lastYPos = 0;   // poprzednie położenie pionowe

int prevSensorValue = 0;    // poprzednia wartość czujnika
boolean catOnMat = false;   // czy kot jest na macie
int threshold = 200;        // powyżej tej wartości kot jest na macie

int lineColor = #C7AFDE;

float sensorValue = 0;
float lastSensorValue = 0;

Capture myCam;
String fileName = "catcam.jpg";

String baseUrl = "/mtt2/save2web.php";
String boundary = "----H4rkNrF";
Client thisClient;

void setup() {
  size(640, 480);

  // Aby użyć innego urządzenia (np. jeśli domyślne urządzenie powoduje bląd),
  // wyświetl listę dostępnych urządzeń do przechwytywania obrazu aby znaleźć swoją kamerę.
  String[] devices = Capture.list();
  println(devices);

  // Zmień devices[0] na prawidlowy indeks twojej kamery.
  myCam = new Capture(this, width, height, devices[2]);

  myPort = new Serial(this, Serial.list()[0], 9600);
  // nie generuj serialEvent() o ile nie dostanies znaku nowego wiersza:
  myPort.bufferUntil('\n');
}


void draw() {
  if (myCam.available() == true) {
    // narysuj obraz z kamery na ekranie
    myCam.read();
    set(0, 0, myCam);

    // pobierz czas jako łańcuch znaków:
    String timeStamp = nf(hour(), 2) + ":" + nf(minute(), 2) 
      + ":" + nf(second(), 2) + " " + nf(day(), 2) + "-" 
        + nf(month(), 2) + "-" +  nf(year(), 4);

    // narysuj cień pod tekstem z czasem:
    fill(15);
    text(timeStamp, 11, height - 19);
    // narysuj główny tekst z czasem:
    fill(255);
    text(timeStamp, 10, height - 20);
  }
} 
void clientEvent (Client thisClient) {
  // jeśli są przychodzące dane z klienta
  // to przechwyć je i wypisz
  while (thisClient.available() > 0) { 
    String data = thisClient.readString(); 
    println(data);
  }
}

void keyReleased() {
  takePicture();
  postPicture();
}


void takePicture() {
  PImage img = get();
  img.save(fileName);
  // loadStrings("http://www.www.example.com/mailer.php");
}


void postPicture() {
  // załaduj zapisany obraz do tablicy bajtów:
  byte[] thisFile =loadBytes(fileName);

  // otwórz nowe połączenie z serwerem:
  thisClient = new Client(this, "www.tigoe.net", 80);
  // skonstruuj żądanie HTTP POST:
  thisClient.write("POST " + baseUrl + " HTTP/1.1\n"); 
  thisClient.write("Host: www.tigoe.net\n");
  // powiedz serwerowi, że wysyłasz żądanie POST w wielu częściach,
  // i wyślij unikatowy ciąg, który będzie rozdzielał części:
  thisClient.write("Content-Type: multipart/form-data; boundary=");
  thisClient.write(boundary + "\n");

  // sformułuj początek żądania:
  String requestHead ="\n--" + boundary + "\n";
  requestHead +="Content-Disposition: form-data; name=\"file\"; ";
  requestHead += "filename=\"" + fileName + "\"\n";
  requestHead +="Content-Type: image/jpeg\n\n";

  // sformułuj koniec żądania:
  String tail ="\n\n--" + boundary + "--\n\n";

  // oblicz i wyślij długość całego żądania,
  // wliczając w to nagłówek żądania, plik i ogon:
  int contentLength = requestHead.length() + thisFile.length + tail.length();
  thisClient.write("Content-Length: " + contentLength + "\n");  

  // wyślij nagłówek żądania, plik i ogon:
  thisClient.write(requestHead);
  thisClient.write(thisFile);
  thisClient.write(tail);

  // close the client:
 // thisClient.stop();
}


void serialEvent (Serial myPort) {
  // pobierz łańcuch  znaków ASCII :
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    // wytnij wszystkie odstępy :
    inString = trim(inString);
    // konwertuj do liczb całkowitych i mapuj do wysokości ekranu:
    sensorValue = float(inString); 
    //println(sensorValue);
    sensorValue = map(sensorValue, 0, 1023, 0, height);
    //  yPos = height - sensorValue;
  }

  if (sensorValue > threshold ) {

    // jeśli ostatni odczyt był mniejszy od progu,
    // to kot właśnie jest na macie.
    if (prevSensorValue <= threshold) {
      catOnMat = true;
        //sendMail();

      //   lineColor =  #F9FA38;
      println("crossed threshold");
      takePicture();
      postPicture();
    }
  } 
  else {
    // jeśli wartość czujnika jest mniejsza niż próg ,
    // a poprzednia wartość była większa, to kot 
    // właśnie opuścił matę
    if (lastSensorValue > threshold) {
      catOnMat = false;
      //  lineColor = #C7AFDE;  
      println("kota nie ma na macie");
    }
  }
  lastSensorValue = sensorValue;
}



