﻿/*
   Odczyt czujników
   Kontekst: Arduino
   
   Odczytuje wartości z dwóch wejść analogowych 
   i dwóch wejść cyfrowych oraz wysyła ich wartości.
   
   Połączenia:
     czujniki analogowe do pinów wejść analogowych numer 0 i 1
     przyciski do pinów cyfrowych wejścia-wyjścia numer 2 i 3
*/

const int leftSensor = 0;      // wejście analogowe dla lewego ramienia
const int rightSensor = 1;     // wejście analogowe dla prawego ramienia
const int resetButton = 2;     // wejście cyfrowe dla przycisku reset
const int serveButton = 3;     // wejście cyfrowe dla przycisku serw

int leftValue = 0;             // odczyt z lewego ramienia
int rightValue = 0;            // odczyt z prawego ramienia
int reset = 0;                 // odczyt z przycisku resert
int serve = 0;                 // odczyt z przycisku serw

void setup() {
  // konfiguracja połączenia szeregowego:
  Serial.begin(9600);
  
  // konfiguracja wejść cyfrowych:
  pinMode(resetButton, INPUT);
  pinMode(serveButton, INPUT);
}

void loop() {
  // odczyt czujników analogowych:
  leftValue = analogRead(leftSensor);
  rightValue = analogRead(rightSensor);
  
  // odczyt czujników cyfrowych:
  reset = digitalRead(resetButton);
  serve = digitalRead(serveButton);
  
  // wydruk wyników:
  Serial.print(leftValue);
  Serial.print(",");
  Serial.print(rightValue);
  Serial.print(",");
  Serial.print(reset);
  Serial.print(",");
  // wydrukuj wartość z ostatniego czujnika przy użyciu println(), 
  // żeby każdy zestaw czterech wyników był wyświetlany 
  // w osobnym wierszu:
  Serial.println(serve);
}
