﻿/*
Program rysujący trójkąty
Kontekst: Processing

Rysuje trójkąt, gdy przycisk myszy nie jest wciśnięty.
Wymazuje po naciśnięciu przycisku myszy. 
*/

// deklaracja zmiennych:
float redValue = 0;   // zmienna do przechowywania koloru czerwonego
float greenValue = 0; // zmienna do przechowywania koloru zielonego
float blueValue = 0;  // zmienna do przechowywania koloru niebieskiego

// metoda setup() jest wykonywana raz na początku programu:

void setup() {
  size(320, 240);   // ustawia rozmiar okna apletu 
  background(0);    // ustawia kolor  tła okna na czarny
  fill(0);          // ustawia kolor wypełnienia 
		    // kształtów z (0 = czarny)
  smooth();         // rysowanie z wygładzaniem krawędzi 
}

// metoda draw() będzie uruchamiana wielokrotnie, 
// dopóty, dopóki okno apletu jest otwarte. 
// Odświeża okno i robi wszystko inne, 
// co zaprogramujesz:

void draw() {

  // wybierz losowo kolory dla składnika 
  // czerwonego, zielonego i niebieskiego:
  redValue = random(255);
  greenValue = random(255);
  blueValue = random(255);

  // ustaw kolor linii:
  stroke(redValue, greenValue, blueValue);

  // rysuj trójkąt, gdy przycisk myszy 
  // nie jest wciśnięty (do diabła z konwencją):
  if (mousePressed == false) {
    // rysuj trójkąt
    triangle(mouseX, mouseY, width/2, height/2,pmouseX, pmouseY);
  }
  // wymaż, kiedy przycisk myszy jest wciśnięty:
  else {
    background(0);
    fill(0);
  }
}
